/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;

public class RetryBackoffUtils {
    private RetryBackoffUtils() {
        throw new UnsupportedOperationException("This is a utility class and should not be instantiated");
    }

    public static Duration calculateDelay(int retryCount, @Nonnull Duration baseDelay, @Nonnull Duration maxDelay) {
        Preconditions.checkArgument((retryCount >= 0 ? 1 : 0) != 0, (String)"Retry count must not be negative, was %s", (int)retryCount);
        Objects.requireNonNull(baseDelay, "baseDelay");
        Objects.requireNonNull(maxDelay, "maxDelay");
        try {
            long multiplicand = LongMath.checkedPow((long)2L, (int)retryCount) / 2L;
            if (multiplicand <= 1L) {
                return baseDelay;
            }
            Duration delay = baseDelay.multipliedBy(multiplicand);
            if (delay.compareTo(maxDelay) > 0) {
                return maxDelay;
            }
            return delay;
        }
        catch (ArithmeticException e) {
            return maxDelay;
        }
    }
}

