/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class TimerUtils {
    private TimerUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static boolean isActive() {
        return Timers.getConfiguration().isEnabled() || Metrics.getConfiguration().isEnabled();
    }

    public static Timer start(@Nonnull String name) {
        return new DefaultTimer(name);
    }

    public static <T, E extends Throwable> T time(String name, Operation<T, E> supplier) throws E {
        try (Ticker ignored = Timers.timer((String)name).start(new String[0]);){
            Object object = supplier.perform();
            return (T)object;
        }
    }

    private static class DefaultTimer
    implements Timer {
        private Ticker ticker;
        private boolean stopped;

        private DefaultTimer(String currentName) {
            this.ticker = Timers.timer((String)Objects.requireNonNull(currentName, "currentName")).start(new String[0]);
        }

        @Override
        public void close() {
            if (this.stopped) {
                if (DevModeUtils.isEnabled()) {
                    throw new IllegalStateException("Stop should only be called once");
                }
                return;
            }
            this.ticker.close();
            this.stopped = true;
        }

        @Override
        public void mark(@Nonnull String newName) {
            Objects.requireNonNull(newName, "newName");
            this.ticker.close();
            this.ticker = Timers.timer((String)newName).start(new String[0]);
        }
    }
}

