/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util.web;

import com.atlassian.bitbucket.util.ResettableInputStream;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.InputStream;

public class ResettableHttpServletRequest
extends HttpServletRequestWrapper {
    private volatile ResettableServletInputStream servletInputStream;

    public ResettableHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public synchronized ServletInputStream getInputStream() throws IOException {
        if (this.servletInputStream == null) {
            this.servletInputStream = new ResettableServletInputStream(super.getInputStream());
        }
        return this.servletInputStream;
    }

    public void reset() {
        if (this.servletInputStream != null) {
            this.servletInputStream.resetStream();
        }
    }

    private static class ResettableServletInputStream
    extends ServletInputStream {
        private final ServletInputStream inputStream;
        private final ResettableInputStream resettableStream;

        private ResettableServletInputStream(ServletInputStream inputStream) {
            this.inputStream = inputStream;
            this.resettableStream = new ResettableInputStream((InputStream)inputStream);
            this.resettableStream.mark(2048);
        }

        public int available() throws IOException {
            return this.resettableStream.available();
        }

        public void close() throws IOException {
            this.resettableStream.close();
        }

        public boolean isFinished() {
            return this.inputStream.isFinished() && this.availableOrZero() == 0;
        }

        public boolean isReady() {
            return this.inputStream.isReady() || this.availableOrZero() > 0;
        }

        public synchronized void mark(int readlimit) {
            this.resettableStream.mark(readlimit);
        }

        public boolean markSupported() {
            return this.resettableStream.markSupported();
        }

        public int read() throws IOException {
            return this.resettableStream.read();
        }

        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            return this.resettableStream.read(b, off, len);
        }

        public synchronized void reset() throws IOException {
            this.resettableStream.reset();
        }

        public void resetStream() {
            try {
                this.resettableStream.reset();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public void setReadListener(ReadListener readListener) {
            this.inputStream.setReadListener(readListener);
        }

        private int availableOrZero() {
            try {
                return this.resettableStream.available();
            }
            catch (IOException e) {
                return 0;
            }
        }
    }
}

