/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.operator.OutputAEADEncryptor;
import org.bouncycastle.operator.OutputEncryptor;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    private CMSEnvelopedData doGenerate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        ASN1EncodableVector recipientInfos = CMSUtils.getRecipentInfos(contentEncryptor.getKey(), this.recipientInfoGenerators);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            cOut.close();
            if (contentEncryptor instanceof OutputAEADEncryptor) {
                byte[] mac = ((OutputAEADEncryptor)contentEncryptor).getMAC();
                bOut.write(mac, 0, mac.length);
            }
        }
        catch (IOException e) {
            throw new CMSException("");
        }
        byte[] encryptedContent = bOut.toByteArray();
        EncryptedContentInfo eci = CMSUtils.getEncryptedContentInfo(content, contentEncryptor, encryptedContent);
        ASN1Set unprotectedAttrSet = CMSUtils.getAttrBERSet(this.unprotectedAttributeGenerator);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, (ASN1Encodable)new EnvelopedData(this.originatorInfo, (ASN1Set)new DERSet(recipientInfos), eci, unprotectedAttrSet));
        return new CMSEnvelopedData(contentInfo);
    }

    public CMSEnvelopedData generate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

