/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.basicauth.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.config.SsoConfigCachingService;
import com.atlassian.plugins.authentication.basicauth.event.BasicAuthAttemptedEvent;
import com.atlassian.plugins.authentication.basicauth.filter.DisableBasicAuthResponseWriter;
import com.atlassian.plugins.authentication.basicauth.service.BasicAuthRequestMatcher;
import com.atlassian.plugins.authentication.basicauth.service.CachingBasicAuthService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UrlPathHelper;

@UnrestrictedAccess
public class DisableBasicAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DisableBasicAuthFilter.class);
    @VisibleForTesting
    static final String INVALIDATE_SESSION_SYSTEM_PROPERTY = "com.atlassian.plugins.authentication.basic.auth.filter.invalidate.session";
    static final String FORCE_ALLOW_BASIC_AUTH_SYSTEM_PROPERTY = "com.atlassian.plugins.authentication.basic.auth.filter.force.allow";
    public static final String BASIC_AUTH_EVENT_SAMPLING_RATE_SYS_PROP = "com.atlassian.plugins.authentication.basic.auth.event.sampling.rate";
    public static final double DEFAULT_BASIC_AUTH_SAMPLING_RATE = 0.05;
    private static final String BASIC_AUTH_TYPE_PREFIX = "Basic ";
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();
    private final CachingBasicAuthService cachingBasicAuthService;
    private final DisableBasicAuthResponseWriter disableBasicAuthResponseWriter;
    private final SsoConfigCachingService ssoConfigCachingService;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;
    private final EventPublisher eventPublisher;
    private final boolean basicAuthAllowed;
    private final double basicAuthEventSamplingRate = DisableBasicAuthFilter.getSamplingRate();

    public DisableBasicAuthFilter(CachingBasicAuthService cachingBasicAuthService, DisableBasicAuthResponseWriter disableBasicAuthResponseWriter, SsoConfigCachingService ssoConfigCachingService, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService, EventPublisher eventPublisher) {
        this.cachingBasicAuthService = cachingBasicAuthService;
        this.disableBasicAuthResponseWriter = disableBasicAuthResponseWriter;
        this.ssoConfigCachingService = ssoConfigCachingService;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
        this.eventPublisher = eventPublisher;
        this.basicAuthAllowed = Boolean.getBoolean(FORCE_ALLOW_BASIC_AUTH_SYSTEM_PROPERTY);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        Result result = this.checkRequest(request);
        if (result == Result.ALLOW_REQUEST) {
            log.trace("Allowing HTTP request: {}", (Object)request.getRequestURI());
            this.sampleBasicAuthEvent();
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (result == Result.BLOCK_REQUEST) {
            log.trace("Blocking HTTP request - Basic Authentication is not allowed: {}", (Object)request.getRequestURI());
            this.disableBasicAuthResponseWriter.write(request, response, Response.Status.FORBIDDEN);
        } else if (result == Result.INVALIDATE_SESSION) {
            log.trace("Allowing HTTP request: {}", (Object)request.getRequestURI());
            this.sampleBasicAuthEvent();
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (!"false".equalsIgnoreCase(System.getProperty(INVALIDATE_SESSION_SYSTEM_PROPERTY))) {
                this.invalidateSession(request);
            }
        }
    }

    private static double getSamplingRate() {
        String property = System.getProperty(BASIC_AUTH_EVENT_SAMPLING_RATE_SYS_PROP, Double.toString(0.05));
        try {
            return Double.parseDouble(property);
        }
        catch (NumberFormatException ignored) {
            return 0.05;
        }
    }

    private void sampleBasicAuthEvent() {
        if (this.shouldSampleEvent()) {
            this.eventPublisher.publish((Object)new BasicAuthAttemptedEvent());
        }
    }

    private boolean shouldSampleEvent() {
        return Math.random() < this.basicAuthEventSamplingRate;
    }

    private void invalidateSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            try {
                log.debug("Invalidating session {} for HTTP request: {}", (Object)session.getId(), (Object)request.getRequestURI());
                session.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private boolean isNativeLoginEnabled() {
        return this.ssoConfigCachingService.get().getShowLoginForm() || this.ssoConfigCachingService.get().enableAuthenticationFallback();
    }

    private Result invalidateSessionIfNativeLoginRestricted() {
        if (!this.isNativeLoginEnabled()) {
            log.debug("Session for Basic Authentication will be invalidated because login form is disabled");
            return Result.INVALIDATE_SESSION;
        }
        if (!this.authenticationPluginFeatureService.isLegacyModeEnabled()) {
            log.debug("Session for Basic Authentication will be invalidated because the 2SV-capable login mode is enabled");
            return Result.INVALIDATE_SESSION;
        }
        log.debug("Session will be kept, allowing the request..");
        return Result.ALLOW_REQUEST;
    }

    private Result checkRequest(HttpServletRequest request) {
        String authorizationHeader = StringUtils.trim((String)request.getHeader("Authorization"));
        BasicAuthRequestMatcher matcher = this.cachingBasicAuthService.getMatcher();
        if (this.isBasicAuthorizationHeader(authorizationHeader)) {
            if (!this.basicAuthAllowed && matcher.isBlockRequests()) {
                String path = URL_PATH_HELPER.getPathWithinApplication(request);
                String user = this.decodeBasicAuthorizationUsername(authorizationHeader);
                log.debug("Basic Authentication is not allowed, checking if request is allow-listed (path={}, user={})", (Object)path, (Object)user);
                if (matcher.isPathAllowed(path)) {
                    log.debug("Path is allowed - allowing the request, but will invalidate session afterwards (path={}, user={})", (Object)path, (Object)user);
                    return Result.INVALIDATE_SESSION;
                }
                if (matcher.isUserAllowed(user)) {
                    log.debug("User is allowed - allowing the request (path={}, user={})", (Object)path, (Object)user);
                    return this.invalidateSessionIfNativeLoginRestricted();
                }
                log.debug("Neither path nor user are allowed - blocking the request (path={}, user={})", (Object)path, (Object)user);
                return Result.BLOCK_REQUEST;
            }
            return this.invalidateSessionIfNativeLoginRestricted();
        }
        return Result.ALLOW_REQUEST;
    }

    private boolean isBasicAuthorizationHeader(@Nullable String header) {
        return StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)BASIC_AUTH_TYPE_PREFIX);
    }

    @Nullable
    private String decodeBasicAuthorizationUsername(@Nullable String authHeader) {
        try {
            String encodedCredentials = StringUtils.substring((String)authHeader, (int)BASIC_AUTH_TYPE_PREFIX.length());
            String decodedCredentials = new String(Base64.getDecoder().decode(encodedCredentials));
            return StringUtils.substringBefore((String)decodedCredentials, (String)":");
        }
        catch (IllegalArgumentException e) {
            log.debug("Could not decode Authorisation header - not a base64 encoded value", (Throwable)e);
            return null;
        }
    }

    public void destroy() {
    }

    private static enum Result {
        BLOCK_REQUEST,
        INVALIDATE_SESSION,
        ALLOW_REQUEST;

    }
}

