/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.basicauth.rest;

import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.basicauth.rest.model.BasicAuthConfigEntity;
import com.atlassian.plugins.authentication.basicauth.service.BasicAuthDao;
import com.atlassian.plugins.authentication.basicauth.service.CachingBasicAuthService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@SystemAdminOnly
@BasePathDoc(value="/basicauth/latest")
@Tag(name="Authentication")
public class BasicAuthResource {
    private final BasicAuthDao basicAuthDao;
    private final CachingBasicAuthService cachingBasicAuthService;

    @Inject
    public BasicAuthResource(BasicAuthDao basicAuthDao, CachingBasicAuthService cachingBasicAuthService) {
        this.basicAuthDao = basicAuthDao;
        this.cachingBasicAuthService = cachingBasicAuthService;
    }

    @Operation(description="Get the current configuration for blocking basic authentication requests.", summary="Get basic auth configuration")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The blocking basic authentication configuration.", representation=BasicAuthConfigEntity.class)})
    @GET
    public BasicAuthConfigEntity get() {
        return BasicAuthConfigEntity.fromConfig(this.basicAuthDao.get());
    }

    @Operation(description="Store a new configuration for blocking basic authentication requests.", summary="Update basic auth configuration")
    @RequestBody(description="A request containing the new basic authentication configuration.", content={@Content(schema=@Schema(implementation=BasicAuthConfigEntity.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="The basic authentication blocking configuration was successfully created or updated."), @ResponseDoc(responseCode=409, documentation="Unable to update the basic authentication blocking configuration as another update is currently being performed.", restError=true)})
    @PUT
    public Response put(BasicAuthConfigEntity basicAuthConfig) {
        this.basicAuthDao.save(basicAuthConfig::toConfig);
        this.cachingBasicAuthService.update();
        return Response.noContent().build();
    }
}

