/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.basicauth.service;

import com.atlassian.plugins.authentication.api.config.BasicAuthService;
import com.atlassian.plugins.authentication.basicauth.BasicAuthConfig;
import com.atlassian.plugins.authentication.basicauth.service.BasicAuthDao;
import com.atlassian.plugins.authentication.basicauth.service.BasicAuthRequestMatcher;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CachingBasicAuthService
implements BasicAuthService {
    private final BasicAuthDao basicAuthDao;
    private volatile BasicAuthRequestMatcher matcher;

    public CachingBasicAuthService(BasicAuthDao basicAuthDao) {
        this.basicAuthDao = basicAuthDao;
        this.update();
    }

    public void update() {
        this.matcher = new BasicAuthRequestMatcher(this.basicAuthDao.get());
    }

    public BasicAuthConfig getConfig() {
        return this.matcher.getConfig();
    }

    public BasicAuthRequestMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isDisabled() {
        this.update();
        return this.matcher.isBlockRequests();
    }
}

