/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.captcha.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bamboo.security.BambooCaptchaValidationService;
import com.atlassian.plugins.authentication.captcha.CaptchaService;
import com.atlassian.plugins.authentication.captcha.model.CaptchaDataEntity;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooCaptchaService
implements CaptchaService {
    private static final Logger LOG = LoggerFactory.getLogger(BambooCaptchaService.class);
    public static final String CAPTCHA_URL = "/parameterCaptcha?captchaId=";
    private final RandomElementGenerator randomElementGenerator;
    private final ApplicationProperties applicationProperties;
    private final BambooCaptchaValidationService captchaValidationService;

    public BambooCaptchaService(ApplicationProperties applicationProperties, BambooCaptchaValidationService captchaValidationService) {
        this.applicationProperties = applicationProperties;
        this.captchaValidationService = captchaValidationService;
        this.randomElementGenerator = new RandomElementGenerator();
    }

    @VisibleForTesting
    public BambooCaptchaService(ApplicationProperties applicationProperties, BambooCaptchaValidationService captchaValidationService, RandomElementGenerator randomElementGenerator) {
        this.applicationProperties = applicationProperties;
        this.captchaValidationService = captchaValidationService;
        this.randomElementGenerator = randomElementGenerator;
    }

    @Override
    @Nonnull
    public CaptchaDataEntity getCaptchaData(@Nonnull HttpServletRequest request) {
        String captchaId = String.valueOf(this.randomElementGenerator.generatePositiveInt());
        return new CaptchaDataEntity(captchaId, this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + CAPTCHA_URL + captchaId);
    }

    @Override
    public boolean isCaptchaRequired(@Nonnull String userName) {
        return this.captchaValidationService.isRequired(userName);
    }

    @Override
    public boolean isValid(String captchaId, String captchaChallenge) {
        boolean isCaptchaIdMissing = Strings.isNullOrEmpty((String)captchaId);
        boolean isCaptchaChallengeMissing = Strings.isNullOrEmpty((String)captchaChallenge);
        if (isCaptchaIdMissing || isCaptchaChallengeMissing) {
            LOG.info(BambooCaptchaService.constructCaptchaMessage(isCaptchaIdMissing, isCaptchaChallengeMissing));
            return false;
        }
        return this.captchaValidationService.validate(captchaId, captchaChallenge);
    }

    static String constructCaptchaMessage(boolean isCaptchaIdMissing, boolean isCaptchaChallengeMissing) {
        return "Attempted to validate captcha with missing data: " + (isCaptchaIdMissing ? "[capchaId]" : "") + (isCaptchaIdMissing && isCaptchaChallengeMissing ? ", " : "") + (isCaptchaChallengeMissing ? "[captchaChallenge]" : "") + " evaluated to null or empty string";
    }

    static class RandomElementGenerator {
        private final SecureRandom gen = new SecureRandom();

        RandomElementGenerator() {
        }

        public int generatePositiveInt() {
            return this.gen.nextInt(1, Integer.MAX_VALUE);
        }
    }
}

