/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.captcha.impl;

import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.plugins.authentication.captcha.CaptchaService;
import com.atlassian.plugins.authentication.captcha.model.CaptchaDataEntity;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;

public class ConfluenceCaptchaService
implements CaptchaService {
    private static final String CAPTCHA_URL = "/jcaptcha/?action=login&id=";
    private final CaptchaManager captchaManager;
    private final LoginManager loginManager;
    private final ApplicationProperties applicationProperties;

    public ConfluenceCaptchaService(CaptchaManager captchaManager, LoginManager loginManager, ApplicationProperties applicationProperties) {
        this.captchaManager = captchaManager;
        this.loginManager = loginManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    @Nonnull
    public CaptchaDataEntity getCaptchaData(@Nonnull HttpServletRequest request) {
        String captchaId = this.captchaManager.generateCaptchaId();
        return CaptchaDataEntity.builder().setCaptchaId(captchaId).setCaptchaImageUrl(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + CAPTCHA_URL + captchaId).build();
    }

    @Override
    public boolean isCaptchaRequired(@Nonnull String userName) {
        return this.captchaManager.isCaptchaAvailable() && this.loginManager.requiresElevatedSecurityCheck(userName);
    }

    @Override
    public boolean isValid(@Nonnull String captchaId, @Nonnull String captchaChallenge) {
        return this.captchaManager.forceValidateCaptcha(captchaId, captchaChallenge);
    }
}

