/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.config.IdpConfig;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.SsoConfig;
import com.atlassian.plugins.authentication.api.config.SsoConfigService;
import com.atlassian.plugins.authentication.basicauth.BasicAuthConfig;
import com.atlassian.plugins.authentication.basicauth.service.BasicAuthDao;
import com.atlassian.plugins.authentication.common.analytics.AbstractStatisticsCollectionService;
import com.atlassian.plugins.authentication.common.analytics.events.AuthFallbackStatusAnalyticsEvent;
import com.atlassian.plugins.authentication.common.analytics.events.BasicAuthStatusEvent;
import com.atlassian.plugins.authentication.common.analytics.events.IdpConfigStatusAnalyticsEvent;
import com.atlassian.plugins.authentication.common.analytics.events.LoginFormStatusAnalyticsEvent;
import com.atlassian.plugins.authentication.common.analytics.events.TsvStatsAnalyticsEvent;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterWideStatisticsCollectionService
extends AbstractStatisticsCollectionService {
    private static final Logger log = LoggerFactory.getLogger(ClusterWideStatisticsCollectionService.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)ClusterWideStatisticsCollectionService.class.getCanonicalName());
    private static final JobId JOB_ID = JobId.of((String)"analytics-collection");
    private final SsoConfigService ssoConfigService;
    private final IdpConfigService idpConfigService;
    private final BasicAuthDao basicAuthDao;
    private final AuthenticationPluginFeatureInternalService authFeatureService;
    private final TotpUserEnrollmentDao totpUserEnrollmentDao;
    private final ApplicationProperties applicationProperties;

    public ClusterWideStatisticsCollectionService(EventPublisher eventPublisher, SchedulerService schedulerService, SsoConfigService ssoConfigService, IdpConfigService idpConfigService, BasicAuthDao basicAuthDao, AuthenticationPluginFeatureInternalService authFeatureService, TotpUserEnrollmentDao totpUserEnrollmentDao, ApplicationProperties applicationProperties) {
        super(eventPublisher, schedulerService);
        this.ssoConfigService = ssoConfigService;
        this.idpConfigService = idpConfigService;
        this.basicAuthDao = basicAuthDao;
        this.authFeatureService = authFeatureService;
        this.totpUserEnrollmentDao = totpUserEnrollmentDao;
        this.applicationProperties = applicationProperties;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        List<IdpConfig> idpConfigs = this.getIdpConfigs();
        BasicAuthConfig basicAuthConfig = this.basicAuthDao.get();
        boolean loginPageOnlyEnabled = idpConfigs.isEmpty() && ssoConfig.getShowLoginForm();
        log.debug("Collecting configuration statistics");
        Stream.concat(idpConfigs.stream().map(IdpConfigStatusAnalyticsEvent::new), Stream.of(new LoginFormStatusAnalyticsEvent(ssoConfig), new AuthFallbackStatusAnalyticsEvent(ssoConfig, idpConfigs), new BasicAuthStatusEvent(basicAuthConfig), new TsvStatsAnalyticsEvent(this.authFeatureService.isLegacyModeEnabled(), this.authFeatureService.isEnforcementEnabledForAdmins(), this.authFeatureService.isEnforcementEnabledForAllUsers(), !this.authFeatureService.isRateLimitingDisabled(), loginPageOnlyEnabled, this.authFeatureService.supportsTwoStepVerificationWebsudo(), !this.authFeatureService.isTsvWebsudoDisabled(), this.countEnrollments()))).forEach(this::tryPublish);
        return JobRunnerResponse.success();
    }

    @Override
    @Nonnull
    protected RunMode getRunMode() {
        return RunMode.RUN_ONCE_PER_CLUSTER;
    }

    @Override
    protected JobId getJobId() {
        return JOB_ID;
    }

    @Override
    protected JobRunnerKey getJobRunnerKey() {
        return JOB_RUNNER_KEY;
    }

    private Integer countEnrollments() {
        try {
            return this.totpUserEnrollmentDao.countAllEnrollmentsFast();
        }
        catch (Exception e) {
            log.error("Failed to count all enrollments. Returning value 'null' indicating an error", (Throwable)e);
            return null;
        }
    }

    private List<IdpConfig> getIdpConfigs() {
        if (this.applicationProperties.getPlatformId().equals("crowd")) {
            return List.of();
        }
        return this.idpConfigService.getIdpConfigs();
    }
}

