/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.properties.bamboo;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.properties.SystemPropertyBasedAuthenticationPluginFeatureService;

public class BambooAuthenticationPluginFeatureService
implements AuthenticationPluginFeatureInternalService {
    private final SystemPropertyBasedAuthenticationPluginFeatureService systemPropertyBasedAuthenticationPluginFeatureService;

    public BambooAuthenticationPluginFeatureService(SystemPropertyBasedAuthenticationPluginFeatureService systemPropertyBasedAuthenticationPluginFeatureService) {
        this.systemPropertyBasedAuthenticationPluginFeatureService = systemPropertyBasedAuthenticationPluginFeatureService;
    }

    public boolean isLegacyModeEnabled() {
        String rawLegacyModeValue = this.systemPropertyBasedAuthenticationPluginFeatureService.getRawLegacyModeValue();
        if (rawLegacyModeValue != null) {
            return !rawLegacyModeValue.equals("false");
        }
        return this.getBambooPropertyValue();
    }

    public boolean isTsvWebsudoDisabled() {
        return true;
    }

    @Override
    public boolean isEnforcementEnabledForAdmins() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isEnforcementEnabledForAdmins();
    }

    @Override
    public boolean isEnforcementEnabledForAllUsers() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isEnforcementEnabledForAllUsers();
    }

    @Override
    public boolean isRateLimitingDisabled() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isRateLimitingDisabled();
    }

    @Override
    public boolean isSamlAuthRequestsSigningEnabled() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isSamlAuthRequestsSigningEnabled();
    }

    @VisibleForTesting
    protected boolean getBambooPropertyValue() {
        try {
            return SystemProperty.ATLASSIAN_AUTHENTICATION_BAMBOO_LEGACY_MODE.getTypedValue();
        }
        catch (Throwable t) {
            return true;
        }
    }
}

