/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.properties.confluence;

import com.atlassian.confluence.cluster.ZduManager;
import com.atlassian.confluence.cluster.ZduStatus;
import com.atlassian.confluence.event.events.cluster.ZduFinalizationRequestEvent;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceAuthenticationPluginFeatureEventListener
implements LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceAuthenticationPluginFeatureEventListener.class);
    public static final int CONFLUENCE_9_BUILD_NUMBER = 21000;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final EventPublisher eventPublisher;
    private final ZduManager zduManager;

    public ConfluenceAuthenticationPluginFeatureEventListener(PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher, ZduManager zduManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.eventPublisher = eventPublisher;
        this.zduManager = zduManager;
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
    }

    public void onStop() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onZduFinalizationRequestEvent(ZduFinalizationRequestEvent e) {
        logger.debug("Confluence ZDU has ended, setting proper value for 2SV.");
        this.save2SVPropertyToPluginSettings();
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent e) {
        if (this.zduManager.getUpgradeStatus().equals((Object)ZduStatus.disabled())) {
            logger.debug("Confluence startup has ended, setting proper value for 2SV.");
            this.save2SVPropertyToPluginSettings();
        }
    }

    private void save2SVPropertyToPluginSettings() {
        if (Integer.parseInt(BuildInformation.INSTANCE.getMarketplaceBuildNumber()) > 21000) {
            PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
            globalSettings.put("atlassian.authentication.confluence.2sv.installed", (Object)"true");
        }
    }
}

