/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.properties.confluence;

import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.properties.SystemPropertyBasedAuthenticationPluginFeatureService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import io.atlassian.fugue.Suppliers;
import java.util.function.Supplier;

public class ConfluenceAuthenticationPluginFeatureService
implements AuthenticationPluginFeatureInternalService {
    private final Supplier<String> activationFlagSupplier;
    public static final String CONFLUENCE_2SV_PROPERTY = "atlassian.authentication.confluence.2sv.installed";
    private final SystemPropertyBasedAuthenticationPluginFeatureService systemPropertyBasedAuthenticationPluginFeatureService;

    public ConfluenceAuthenticationPluginFeatureService(PluginSettingsFactory pluginSettingsFactory, SystemPropertyBasedAuthenticationPluginFeatureService systemPropertyBasedAuthenticationPluginFeatureService) {
        this.systemPropertyBasedAuthenticationPluginFeatureService = systemPropertyBasedAuthenticationPluginFeatureService;
        this.activationFlagSupplier = Suppliers.weakMemoize(() -> {
            PluginSettings globalSettings = pluginSettingsFactory.createGlobalSettings();
            if (globalSettings.get(CONFLUENCE_2SV_PROPERTY) != null) {
                return (String)globalSettings.get(CONFLUENCE_2SV_PROPERTY);
            }
            return null;
        });
    }

    public boolean isLegacyModeEnabled() {
        String rawLegacyModeValue = this.systemPropertyBasedAuthenticationPluginFeatureService.getRawLegacyModeValue();
        if (rawLegacyModeValue != null) {
            return !rawLegacyModeValue.equals("false");
        }
        String property = this.activationFlagSupplier.get();
        return property == null;
    }

    public boolean isTsvWebsudoDisabled() {
        return true;
    }

    @Override
    public boolean isEnforcementEnabledForAdmins() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isEnforcementEnabledForAdmins();
    }

    @Override
    public boolean isEnforcementEnabledForAllUsers() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isEnforcementEnabledForAllUsers();
    }

    @Override
    public boolean isRateLimitingDisabled() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isRateLimitingDisabled();
    }

    @Override
    public boolean isSamlAuthRequestsSigningEnabled() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isSamlAuthRequestsSigningEnabled();
    }
}

