/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.properties.jira;

import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.properties.SystemPropertyBasedAuthenticationPluginFeatureService;

public class JiraAuthenticationPluginFeatureService
implements AuthenticationPluginFeatureInternalService {
    private static final int JIRA_10_2_0_BUILD_NUMBER = 10020000;
    private static final int JIRA_11_1_0_BUILD_NUMBER = 11010000;
    private final BuildUtilsInfo buildUtilsInfo;
    private final SystemPropertyBasedAuthenticationPluginFeatureService systemPropertyBasedAuthenticationPluginFeatureService;

    public JiraAuthenticationPluginFeatureService(BuildUtilsInfo buildUtilsInfo, SystemPropertyBasedAuthenticationPluginFeatureService systemPropertyBasedAuthenticationPluginFeatureService) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.systemPropertyBasedAuthenticationPluginFeatureService = systemPropertyBasedAuthenticationPluginFeatureService;
    }

    public boolean isLegacyModeEnabled() {
        String rawLegacyModeValue = this.systemPropertyBasedAuthenticationPluginFeatureService.getRawLegacyModeValue();
        if (rawLegacyModeValue != null) {
            return !rawLegacyModeValue.equals("false");
        }
        return this.buildUtilsInfo.getDatabaseBuildNumber() < 10020000;
    }

    public boolean isTsvWebsudoDisabled() {
        return true;
    }

    @Override
    public boolean isEnforcementEnabledForAdmins() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isEnforcementEnabledForAdmins();
    }

    @Override
    public boolean isEnforcementEnabledForAllUsers() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isEnforcementEnabledForAllUsers();
    }

    @Override
    public boolean isRateLimitingDisabled() {
        return this.systemPropertyBasedAuthenticationPluginFeatureService.isRateLimitingDisabled();
    }

    @Override
    public boolean isSamlAuthRequestsSigningEnabled() {
        String rawSamlAuthRequestsSigningValue = this.systemPropertyBasedAuthenticationPluginFeatureService.getRawSamlAuthRequestsSigningValue();
        if (rawSamlAuthRequestsSigningValue != null) {
            return !rawSamlAuthRequestsSigningValue.equals("false");
        }
        return this.buildUtilsInfo.getDatabaseBuildNumber() >= 11010000;
    }
}

