/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.upgrade;

import com.atlassian.plugins.authentication.encryption.EncryptionConfigurationService;
import com.atlassian.plugins.authentication.encryption.EncryptionService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class UpgradeTask07InitializeEncryptor
implements PluginUpgradeTask {
    private final EncryptionConfigurationService encryptionConfigurationService;
    private final EncryptionService encryptionService;

    public UpgradeTask07InitializeEncryptor(EncryptionConfigurationService encryptionConfigurationService, EncryptionService encryptionService) {
        this.encryptionConfigurationService = encryptionConfigurationService;
        this.encryptionService = encryptionService;
    }

    public int getBuildNumber() {
        return 7;
    }

    @Nonnull
    public String getShortDescription() {
        return "Initializes encryptor directory and configures initial encryption key";
    }

    public Collection<Message> doUpgrade() throws Exception {
        Optional<Path> maybeKey = this.encryptionService.generateKey();
        Path encryptionKeyPath = maybeKey.orElseThrow(() -> new IllegalStateException("Cannot generate key as encryption is not available on the instance."));
        this.encryptionConfigurationService.setEncryptionKeyPath(encryptionKeyPath);
        return List.of();
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.plugins.authentication.atlassian-authentication-plugin";
    }
}

