/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.upgrade;

import com.atlassian.plugins.authentication.basicauth.BasicAuthConfig;
import com.atlassian.plugins.authentication.basicauth.service.BasicAuthDao;
import com.atlassian.plugins.authentication.sso.config.PluginSettingsUtil;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpgradeTask09BackfillBasicAuthSetting
implements PluginUpgradeTask {
    private static final String IDP_TYPE_SETTING = "com.atlassian.plugins.authentication.samlconfig.idp-type";
    private static final String BLOCK_REQUESTS_SETTING = "com.atlassian.plugins.authentication.basicauth.block.requests";
    private final BasicAuthDao basicAuthDao;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final boolean isFreshInstall;

    public UpgradeTask09BackfillBasicAuthSetting(PluginSettingsFactory pluginSettingsFactory, BasicAuthDao basicAuthDao) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.basicAuthDao = basicAuthDao;
        this.isFreshInstall = pluginSettingsFactory == null || this.isFreshInstall(pluginSettingsFactory.createGlobalSettings());
    }

    public int getBuildNumber() {
        return 9;
    }

    @Nonnull
    public String getShortDescription() {
        return "For existing installations, back-fill the basic authentication setting if not set to false. This is required as for new installations, the basic authentication setting will be set to true by default.";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws Exception {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        Object blockRequests = settings.get(BLOCK_REQUESTS_SETTING);
        if (!this.isFreshInstall && blockRequests == null) {
            this.basicAuthDao.save(new BasicAuthConfig(false, Collections.emptyList(), Collections.emptyList(), true));
        }
        return ImmutableList.of();
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.plugins.authentication.atlassian-authentication-plugin";
    }

    private boolean isFreshInstall(PluginSettings settings) {
        String pluginUpgradeBuild = (String)settings.get("com.atlassian.plugins.authentication.atlassian-authentication-plugin:build");
        String samlConfig = (String)settings.get(IDP_TYPE_SETTING);
        Optional<Boolean> ssoConfig = PluginSettingsUtil.getBooleanValue(settings, "show-login-form");
        return pluginUpgradeBuild == null && samlConfig == null && ssoConfig.isEmpty();
    }
}

