/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.encryption;

import com.atlassian.plugins.authentication.sso.config.PluginSettingsUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class EncryptionConfigurationService {
    private static final String ENCRYPTION_KEY_FILE_PROPERTY = "encryption-key-path";
    private final ApplicationProperties applicationProperties;
    private final PluginSettingsFactory pluginSettingsFactory;

    public EncryptionConfigurationService(ApplicationProperties applicationProperties, PluginSettingsFactory pluginSettingsFactory) {
        this.applicationProperties = applicationProperties;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Nonnull
    public Path getKeyDirectory() {
        Path homeDirectoryPath = (Path)this.applicationProperties.getSharedHomeDirectory().or(() -> ((ApplicationProperties)this.applicationProperties).getLocalHomeDirectory()).orElseThrow(() -> new IllegalStateException("Neither shared nor local home directory available"));
        Path keyDirectoryPath = homeDirectoryPath.resolve("authentication-plugin-keys");
        try {
            Files.createDirectories(keyDirectoryPath, new FileAttribute[0]);
            return keyDirectoryPath;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public Optional<Path> getEncryptionKeyPath() {
        try {
            return Optional.ofNullable(PluginSettingsUtil.getStringValue(this.pluginSettingsFactory.createGlobalSettings(), ENCRYPTION_KEY_FILE_PROPERTY)).map(x$0 -> Path.of(x$0, new String[0]));
        }
        catch (InvalidPathException e) {
            throw new IllegalStateException("Configured encryption path is invalid", e);
        }
    }

    public void setEncryptionKeyPath(@Nonnull Path encryptionKeyPath) {
        Preconditions.checkArgument((!encryptionKeyPath.isAbsolute() ? 1 : 0) != 0, (Object)"Encryption key path must be relative");
        Path keyPathWithinEncryptionDirectory = this.getKeyDirectory().resolve(encryptionKeyPath).normalize();
        Preconditions.checkArgument((boolean)keyPathWithinEncryptionDirectory.startsWith(this.getKeyDirectory()), (Object)"Encryption key path must be within the configured key directory");
        Preconditions.checkArgument((boolean)keyPathWithinEncryptionDirectory.toFile().exists(), (Object)"Encryption key path must exist");
        PluginSettingsUtil.setStringValue(this.pluginSettingsFactory.createGlobalSettings(), ENCRYPTION_KEY_FILE_PROPERTY, encryptionKeyPath.toString());
    }
}

