/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.encryption.model;

import com.atlassian.plugins.authentication.encryption.model.PlainSecret;
import com.atlassian.plugins.authentication.encryption.model.SealedSecret;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public interface Secret {
    public String serialize();

    public static Secret of(@Nonnull String serializedSecret) {
        if (Objects.requireNonNull(serializedSecret).startsWith("ENCRYPTED:")) {
            return new SealedSecret(serializedSecret.substring("ENCRYPTED:".length()));
        }
        if (serializedSecret.startsWith("PLAIN:")) {
            return new PlainSecret(serializedSecret.substring("PLAIN:".length()));
        }
        throw new IllegalArgumentException("Input string is not a valid serialized secret");
    }

    public static Secret unSealed(@Nonnull String plainSecret) {
        return new PlainSecret(Objects.requireNonNull(plainSecret));
    }

    public static Secret sealed(@Nonnull String sealedSecret) {
        return new SealedSecret(Objects.requireNonNull(sealedSecret));
    }

    public static String rawValue(@Nonnull Secret secret) {
        if (Objects.requireNonNull(secret) instanceof SealedSecret) {
            return secret.serialize().substring("ENCRYPTED:".length());
        }
        if (secret instanceof PlainSecret) {
            return secret.serialize().substring("PLAIN:".length());
        }
        throw new IllegalArgumentException("Cannot extract a raw value from a secret");
    }
}

