/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.config;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.plugins.authentication.api.config.IdpConfig;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.IdpSearchParameters;
import com.atlassian.plugins.authentication.common.audit.AuthAuditCategory;
import com.atlassian.plugins.authentication.common.audit.AuthAuditResourceType;
import com.atlassian.plugins.authentication.sso.config.IdpConfigServiceImpl;
import com.atlassian.plugins.authentication.sso.config.IdpConfigValidatorProvider;
import com.atlassian.plugins.authentication.sso.config.SsoConfigDao;
import com.atlassian.plugins.authentication.sso.config.audit.IdpConfigMappers;
import com.atlassian.plugins.authentication.sso.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.sso.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcDiscoverySupport;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditingIdpConfigService
implements IdpConfigService {
    private static final Logger log = LoggerFactory.getLogger(AuditingIdpConfigService.class);
    public static final String PLUGIN_KEY = "com.atlassian.plugins.authentication.atlassian-authentication-plugin";
    private final IdpConfigService delegate;
    private final IdpConfigMappers idpConfigMappers;
    private final AuditService auditService;

    public AuditingIdpConfigService(SsoConfigDao ssoConfigDao, IdpConfigValidatorProvider idpConfigValidatorProvider, OidcDiscoverySupport oidcDiscoverySupport, ProductLicenseDataProvider productLicenseDataProvider, ApplicationStateValidator applicationStateValidator, IdpConfigMappers idpConfigMappers, AuditService auditService) {
        this(new IdpConfigServiceImpl(ssoConfigDao, idpConfigValidatorProvider, oidcDiscoverySupport, productLicenseDataProvider, applicationStateValidator), idpConfigMappers, auditService);
    }

    @VisibleForTesting
    AuditingIdpConfigService(IdpConfigService delegate, IdpConfigMappers idpConfigMappers, AuditService auditService) {
        this.auditService = auditService;
        this.delegate = delegate;
        this.idpConfigMappers = idpConfigMappers;
    }

    public List<IdpConfig> getIdpConfigs() {
        return this.delegate.getIdpConfigs();
    }

    public List<IdpConfig> getIdpConfigs(IdpSearchParameters searchParameters) {
        return this.delegate.getIdpConfigs(searchParameters);
    }

    public IdpConfig getIdpConfig(Long id) {
        return this.delegate.getIdpConfig(id);
    }

    public IdpConfig updateIdpConfig(@Nonnull IdpConfig newConfig) {
        IdpConfig oldConfig = this.getIdpConfig(newConfig.getId());
        newConfig = this.delegate.updateIdpConfig(newConfig);
        try {
            this.auditService.audit(AuditEvent.fromI18nKeys((String)AuthAuditCategory.SSO_CONFIGURATION.getKey(), (String)"com.atlassian.plugins.authentication.audit.action.update", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION).changedValues(this.idpConfigMappers.mapChanges(oldConfig, newConfig)).affectedObject(AuditResource.builder((String)newConfig.getName(), (String)AuthAuditResourceType.IDP_CONFIGURATION.getValue()).build()).build());
        }
        catch (Exception e) {
            log.error("Could not audit log a new event of idp configuration update", (Throwable)e);
        }
        return newConfig;
    }

    public IdpConfig addIdpConfig(@Nonnull IdpConfig newConfig) {
        IdpConfig idpConfig = this.delegate.addIdpConfig(newConfig);
        try {
            this.auditService.audit(AuditEvent.fromI18nKeys((String)AuthAuditCategory.SSO_CONFIGURATION.getKey(), (String)"com.atlassian.plugins.authentication.audit.action.addition", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION).changedValues(this.idpConfigMappers.mapChanges(null, idpConfig)).affectedObject(AuditResource.builder((String)newConfig.getName(), (String)AuthAuditResourceType.IDP_CONFIGURATION.getValue()).build()).build());
        }
        catch (Exception e) {
            log.error("Could not audit log a new event of new idp configuration creation", (Throwable)e);
        }
        return idpConfig;
    }

    public IdpConfig removeIdpConfig(Long idpConfigId) {
        IdpConfig oldIdpConfig = this.delegate.removeIdpConfig(idpConfigId);
        try {
            this.auditService.audit(AuditEvent.fromI18nKeys((String)AuthAuditCategory.SSO_CONFIGURATION.getKey(), (String)"com.atlassian.plugins.authentication.audit.action.removal", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION).changedValues(this.idpConfigMappers.mapChanges(oldIdpConfig, null)).affectedObject(AuditResource.builder((String)oldIdpConfig.getName(), (String)AuthAuditResourceType.IDP_CONFIGURATION.getValue()).build()).build());
        }
        catch (Exception e) {
            log.error("Could not audit log a new event of new idp configuration removal", (Throwable)e);
        }
        return oldIdpConfig;
    }

    public IdpConfig refreshIdpConfig(IdpConfig configToRefresh) {
        return this.delegate.refreshIdpConfig(configToRefresh);
    }

    static interface I18nKeys {
        public static final String IDP_UPDATED_ACTION_KEY = "com.atlassian.plugins.authentication.audit.action.update";
        public static final String IDP_ADDED_ACTION_KEY = "com.atlassian.plugins.authentication.audit.action.addition";
        public static final String IDP_REMOVED_ACTION_KEY = "com.atlassian.plugins.authentication.audit.action.removal";
    }
}

