/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.config;

import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.IdpLoginOption;
import com.atlassian.plugins.authentication.api.config.IdpSearchParameters;
import com.atlassian.plugins.authentication.api.config.LegacyLoginFormLoginOption;
import com.atlassian.plugins.authentication.api.config.LoginFormLoginOption;
import com.atlassian.plugins.authentication.api.config.LoginGatewayType;
import com.atlassian.plugins.authentication.api.config.LoginOption;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.api.config.SsoConfig;
import com.atlassian.plugins.authentication.api.config.SsoConfigService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.sso.util.ApplicationStateValidator;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LoginOptionsServiceImpl
implements LoginOptionsService {
    private final SsoConfigService ssoConfigService;
    private final IdpConfigService idpConfigService;
    private final ApplicationProperties applicationProperties;
    private final ApplicationStateValidator applicationStateValidator;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;

    public LoginOptionsServiceImpl(SsoConfigService ssoConfigService, IdpConfigService idpConfigService, ApplicationProperties applicationProperties, ApplicationStateValidator applicationStateValidator, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        this.ssoConfigService = ssoConfigService;
        this.idpConfigService = idpConfigService;
        this.applicationProperties = applicationProperties;
        this.applicationStateValidator = applicationStateValidator;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
    }

    public List<LoginOption> getLoginOptions(boolean shouldFallbackOnAuthentication, Set<LoginGatewayType> loginGatewayTypes) {
        List<Object> allLoginOptions;
        String loginLinkBaseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        List<LoginOption> idpLoginOptions = this.idpConfigService.getIdpConfigs(this.resolveSearchParameters(loginGatewayTypes)).stream().filter(this.applicationStateValidator::canProcessAuthenticationRequest).map(idpConfig -> new IdpLoginOption(idpConfig, loginLinkBaseUrl + "/plugins/servlet/external-login")).collect(Collectors.toList());
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        if (this.shouldAppendLoginFormLoginOption(shouldFallbackOnAuthentication, loginGatewayTypes, ssoConfig, idpLoginOptions)) {
            Stream<LoginOption> loginFormLoginOption = Stream.of(this.getLoginOptionBasedOnSystemProperty());
            allLoginOptions = Stream.concat(loginFormLoginOption, idpLoginOptions.stream()).collect(Collectors.toList());
        } else {
            allLoginOptions = idpLoginOptions;
        }
        return allLoginOptions;
    }

    private boolean shouldAppendLoginFormLoginOption(boolean shouldFallbackOnAuthentication, Set<LoginGatewayType> loginGatewayTypes, SsoConfig ssoConfig, List<LoginOption> idpLoginOptions) {
        return this.isShowLoginForm(ssoConfig, loginGatewayTypes) || ssoConfig.enableAuthenticationFallback() && shouldFallbackOnAuthentication || idpLoginOptions.isEmpty() || this.isProductInRecoveryMode();
    }

    private LoginOption getLoginOptionBasedOnSystemProperty() {
        return this.authenticationPluginFeatureService.isLegacyModeEnabled() ? LegacyLoginFormLoginOption.INSTANCE : LoginFormLoginOption.INSTANCE;
    }

    private IdpSearchParameters resolveSearchParameters(Set<LoginGatewayType> loginGatewayTypes) {
        IdpSearchParameters.Builder builder = IdpSearchParameters.builder().setRestrictionType(IdpSearchParameters.IdpRestrictionType.OR);
        loginGatewayTypes.forEach(loginGatewayType -> {
            switch (loginGatewayType) {
                case GLOBAL_LOGIN_GATEWAY: {
                    builder.setEnabledRestriction(Boolean.valueOf(true));
                    break;
                }
                case JSM_LOGIN_GATEWAY: {
                    builder.setIncludeCustomerLoginsRestriction(Boolean.valueOf(true));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported login gateway type: " + String.valueOf(loginGatewayType));
                }
            }
        });
        return builder.build();
    }

    private boolean isShowLoginForm(SsoConfig ssoConfig, Set<LoginGatewayType> loginGatewayTypes) {
        return loginGatewayTypes.stream().map(loginGatewayType -> switch (loginGatewayType) {
            default -> throw new MatchException(null, null);
            case LoginGatewayType.GLOBAL_LOGIN_GATEWAY -> SsoConfig::getShowLoginForm;
            case LoginGatewayType.JSM_LOGIN_GATEWAY -> SsoConfig::getShowLoginFormForJsm;
        }).anyMatch(predicate -> predicate.test(ssoConfig));
    }

    private boolean isProductInRecoveryMode() {
        return System.getProperty("atlassian.recovery.password") != null;
    }
}

