/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.license;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.service.license.LicenseService;
import com.atlassian.extras.api.crowd.CrowdLicense;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import java.util.Set;

public class CrowdLicenseChecker
implements ProductLicenseChecker {
    private final LicenseService licenseService;
    private final PropertyManager propertyManager;

    public CrowdLicenseChecker(LicenseService licenseService, PropertyManager propertyManager) {
        this.licenseService = licenseService;
        this.propertyManager = propertyManager;
    }

    @Override
    public boolean areSlotsAvailable(Set<String> groupNames) {
        CrowdLicense license = this.licenseService.getLicense();
        return license.isUnlimitedNumberOfUsers() || license.getMaximumNumberOfUsers() > this.propertyManager.getCurrentLicenseResourceTotal();
    }
}

