/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.option;

import com.atlassian.plugins.authentication.api.config.IdpConfig;
import com.atlassian.plugins.authentication.api.config.LoginOption;
import com.atlassian.plugins.authentication.sso.web.usercontext.IdpNotApplicableException;
import com.atlassian.plugins.authentication.tsv.exception.LoginFormNotApplicableException;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;

public interface ProductLoginOptionChecker {
    public static final Set<LoginOption.Type> ALLOWED_LOGIN_OPTION_TYPES = ImmutableSet.of((Object)LoginOption.Type.LOGIN_FORM, (Object)LoginOption.Type.LEGACY_LOGIN_FORM);

    public boolean isLoginFormLoginPossible();

    public void checkLoginFormOptionApplicable(UserKey var1, String var2) throws LoginFormNotApplicableException;

    public void checkIdpLoginOptionApplicable(@Nonnull String var1, @Nonnull IdpConfig var2, @Nonnull String var3) throws IdpNotApplicableException;

    default public boolean hasLoginFormLoginOption(List<LoginOption> loginOptions) {
        return loginOptions.stream().anyMatch(loginOption -> ALLOWED_LOGIN_OPTION_TYPES.contains(loginOption.getType()));
    }
}

