/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.rest;

import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.common.rest.model.RestPage;
import com.atlassian.plugins.authentication.common.rest.model.RestPageRequest;
import com.atlassian.plugins.authentication.sso.rest.IdpsResourceService;
import com.atlassian.plugins.authentication.sso.rest.RestPageRequestUtils;
import com.atlassian.plugins.authentication.sso.rest.model.IdpConfigEntity;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;

@Path(value="/idps")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@SystemAdminOnly
@BasePathDoc(value="/authconfig/latest")
@Tag(name="Authentication")
public class IdpsResource {
    private final IdpsResourceService idpsResourceService;

    @Inject
    public IdpsResource(IdpsResourceService idpsResourceService) {
        this.idpsResourceService = idpsResourceService;
    }

    @Operation(description="Returns a page of configured IdPs. \n\nThis endpoint makes no guarantees to ordering besides the ordering being consistent.", summary="Get all configured IdPs")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="A page of configured IdPs.", representation=IdpConfigEntity.class, paged=true)})
    @GET
    public RestPage<IdpConfigEntity> getIdps(@Context UriInfo uriInfo) {
        RestPageRequest pageRequest = RestPageRequestUtils.getRestPageRequest(uriInfo);
        return RestPage.fromListPlusOne(this.idpsResourceService.getConfigs(pageRequest), (RestPageRequest)pageRequest);
    }

    @Operation(description="Creates a new IdP configuration.", summary="Create IdP configuration")
    @RequestBody(description="The configuration of the new IdP to add. The ID must be null.", content={@Content(schema=@Schema(implementation=IdpConfigEntity.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The newly created IdP configuration.", representation=IdpConfigEntity.class), @ResponseDoc(responseCode=400, documentation="The provided IdP configuration was either incorrect or invalid.", restError=true)})
    @POST
    public IdpConfigEntity addIdp(IdpConfigEntity idp) {
        return this.idpsResourceService.addConfig(idp);
    }

    @Operation(description="Returns the configuration for the IdP that matches the given ID.", summary="Get IdP configuration")
    @Parameters(value={@Parameter(description="The ID of the IdP", in=ParameterIn.PATH, name="id")})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The configuration for the given IdP.", representation=IdpConfigEntity.class)})
    @GET
    @Path(value="/{id}")
    public IdpConfigEntity getIdp(@PathParam(value="id") Long id) {
        return this.idpsResourceService.getConfig(id);
    }

    @Operation(description="Updates the configuration for the IdP that matches the given ID. \n\nOnly the provided properties will be applied to the IdP configuration.", summary="Update IdP configuration")
    @Parameters(value={@Parameter(description="The ID of the IdP", in=ParameterIn.PATH, name="id")})
    @RequestBody(description="A request containing the IdP configuration to update. The ID must either be null or equal to the ID specified in the path.", content={@Content(schema=@Schema(implementation=IdpConfigEntity.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The updated configuration for the given IdP.", representation=IdpConfigEntity.class), @ResponseDoc(responseCode=400, documentation="The provided IdP configuration was either incorrect or invalid.", restError=true)})
    @PATCH
    @Path(value="/{id}")
    public IdpConfigEntity updateIdp(@PathParam(value="id") Long id, IdpConfigEntity idpConfigEntity) {
        Preconditions.checkNotNull((Object)id, (Object)"Id must not be null");
        Preconditions.checkArgument((idpConfigEntity.getId() == null || Objects.equals(id, idpConfigEntity.getId()) ? 1 : 0) != 0, (Object)"The ID in the request body must either be null or equal to one in the path");
        return this.idpsResourceService.updateConfig(id, idpConfigEntity);
    }

    @Operation(description="Removes the configuration for the IdP that matches the given ID.", summary="Delete IdP configuration")
    @Parameters(value={@Parameter(description="The ID of the IdP", in=ParameterIn.PATH, name="id")})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The IdP configuration was successfully deleted.", representation=IdpConfigEntity.class)})
    @DELETE
    @Path(value="/{id}")
    public IdpConfigEntity removeIdp(@PathParam(value="id") Long id) {
        return this.idpsResourceService.removeConfig(id);
    }
}

