/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.rest;

import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.sso.rest.JitProvisionedUsersResourceService;
import com.atlassian.plugins.authentication.sso.rest.model.JitUserEntity;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;

@Path(value="/jit-users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@SystemAdminOnly
@BasePathDoc(value="/authconfig/latest")
@Tag(name="Authentication")
public class JitProvisionedUsersResource {
    private final JitProvisionedUsersResourceService jitProvisionedUsersResourceService;

    @Inject
    public JitProvisionedUsersResource(JitProvisionedUsersResourceService jitProvisionedUsersResourceService) {
        this.jitProvisionedUsersResourceService = jitProvisionedUsersResourceService;
    }

    @Operation(description="Returns a list of all the users created by JIT (Just-in-time) provisioning.\n\nJust-in-time user provisioning (JIT provisioning) allows users to be created and updated automatically when they log in through SAML SSO or OpenID Connect (OIDC) SSO.", summary="Get all JIT provisioned users")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="A list of JIT users", representation=JitUserEntity.class)})
    @GET
    public List<JitUserEntity> getJitProvisionedUsers() {
        return this.jitProvisionedUsersResourceService.findJitProvisionedUsers();
    }
}

