/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.rest;

import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.api.config.LoginGatewayType;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.common.rest.model.RestPage;
import com.atlassian.plugins.authentication.common.rest.model.RestPageRequest;
import com.atlassian.plugins.authentication.common.rest.model.SimpleRestPageRequest;
import com.atlassian.plugins.authentication.sso.rest.model.LoginOptionEntity;
import com.atlassian.plugins.authentication.sso.util.JsmUrlChecker;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Path(value="/login-options")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@UnrestrictedAccess
@BasePathDoc(value="/authconfig/latest")
@Tag(name="Authentication")
public class LoginOptionsResource {
    private static final Logger log = LoggerFactory.getLogger(LoginOptionsResource.class);
    private final LoginOptionsService loginOptionsService;
    private final JsmUrlChecker jsmUrlChecker;

    @Inject
    public LoginOptionsResource(LoginOptionsService loginOptionsService, JsmUrlChecker jsmUrlChecker) {
        this.loginOptionsService = loginOptionsService;
        this.jsmUrlChecker = jsmUrlChecker;
    }

    @Operation(description="Returns a list of available login options, which contains details about the metadata required for the login page.\n\nOnly enabled login options will be returned. Login options can either be the native login form or the configured IdPs.", summary="Get available login options")
    @Parameters(value={@Parameter(name="Referer", hidden=true, in=ParameterIn.HEADER)})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="A list of login options", representation=LoginOptionEntity.class, paged=true)})
    @GET
    public RestPage<LoginOptionEntity> getLoginOptions(@HeaderParam(value="Referer") String referer) {
        Optional<UriComponents> refererUrl = this.extractRefererUrl(referer);
        List loginOptions = this.loginOptionsService.getLoginOptions(this.isAuthFallbackQueryParamPresent(refererUrl), this.resolveLoginGatewayType(refererUrl)).stream().map(LoginOptionEntity::new).collect(Collectors.toList());
        return RestPage.fromListPlusOne(loginOptions, (RestPageRequest)SimpleRestPageRequest.ALL_RESULTS_REQUEST);
    }

    private Optional<UriComponents> extractRefererUrl(String referer) {
        try {
            return Optional.of(UriComponentsBuilder.fromHttpUrl((String)referer).build());
        }
        catch (Exception e) {
            log.debug("Could not extract fallback query param from the Referer header", (Throwable)e);
            return Optional.empty();
        }
    }

    private LoginGatewayType resolveLoginGatewayType(Optional<UriComponents> referer) {
        boolean isJsmRequest = referer.map(UriComponents::getPath).map(this.jsmUrlChecker::isJsmRequest).orElse(false);
        return isJsmRequest ? LoginGatewayType.JSM_LOGIN_GATEWAY : LoginGatewayType.GLOBAL_LOGIN_GATEWAY;
    }

    private boolean isAuthFallbackQueryParamPresent(Optional<UriComponents> url) {
        return url.map(u -> u.getQueryParams().containsKey((Object)"auth_fallback")).orElse(false);
    }
}

