/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.rest;

import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.sso.rest.SsoConfigResourceService;
import com.atlassian.plugins.authentication.sso.rest.model.SsoConfigEntity;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Path(value="/sso")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@SystemAdminOnly
@BasePathDoc(value="/authconfig/latest")
@Tag(name="Authentication")
public class SsoConfigResource {
    private final SsoConfigResourceService ssoConfigResourceService;

    @Inject
    public SsoConfigResource(SsoConfigResourceService ssoConfigResourceService) {
        this.ssoConfigResourceService = ssoConfigResourceService;
    }

    @Operation(description="Returns the SSO configuration.", summary="Get SSO configuration")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The SSO configuration", representation=SsoConfigEntity.class)})
    @GET
    public SsoConfigEntity getConfig() {
        return this.ssoConfigResourceService.getConfig();
    }

    @Operation(description="Update the SSO configuration.", summary="Update SSO configuration")
    @RequestBody(description="A request containing the SSO configuration to update.", content={@Content(schema=@Schema(implementation=SsoConfigEntity.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The updated SSO Configuration", representation=SsoConfigEntity.class), @ResponseDoc(responseCode=400, documentation="The provided SSO configuration was invalid.", restError=true)})
    @PATCH
    public SsoConfigEntity updateConfig(SsoConfigEntity ssoConfigEntity) {
        return this.ssoConfigResourceService.updateConfig(ssoConfigEntity);
    }
}

