/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.rest.exception;

import com.atlassian.plugins.authentication.common.rest.model.ErrorEntity;
import com.atlassian.plugins.authentication.sso.config.IdpNotFoundException;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.Serializable;

@Provider
public class IdpNotFoundExceptionMapper
implements ExceptionMapper<IdpNotFoundException> {
    private final I18nResolver i18nResolver;

    @Inject
    public IdpNotFoundExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(IdpNotFoundException exception) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.config.fail.idp.not.found", new Serializable[]{exception.getId()}))).build();
    }
}

