/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.spring;

import com.atlassian.audit.api.AuditService;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.api.config.SsoConfigCachingService;
import com.atlassian.plugins.authentication.api.config.SsoConfigService;
import com.atlassian.plugins.authentication.basicauth.spring.BlockingBasicAuthConfiguration;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.authentication.encryption.EncryptionConfigurationService;
import com.atlassian.plugins.authentication.sso.cache.HybridSsoConfigCache;
import com.atlassian.plugins.authentication.sso.config.AuditingIdpConfigService;
import com.atlassian.plugins.authentication.sso.config.IdpConfigValidatorProvider;
import com.atlassian.plugins.authentication.sso.config.LoginOptionsServiceImpl;
import com.atlassian.plugins.authentication.sso.config.SsoConfigDao;
import com.atlassian.plugins.authentication.sso.config.SsoConfigServiceImpl;
import com.atlassian.plugins.authentication.sso.config.SsoConfigValidator;
import com.atlassian.plugins.authentication.sso.config.audit.IdpConfigMappers;
import com.atlassian.plugins.authentication.sso.data.LoginGatewayDataProvider;
import com.atlassian.plugins.authentication.sso.db.SeenAssertionDao;
import com.atlassian.plugins.authentication.sso.rest.IdpsResourceService;
import com.atlassian.plugins.authentication.sso.rest.JitProvisionedUsersResourceService;
import com.atlassian.plugins.authentication.sso.rest.SsoConfigResourceService;
import com.atlassian.plugins.authentication.sso.spring.ConfigMapperConfiguration;
import com.atlassian.plugins.authentication.sso.spring.DatabaseConfiguration;
import com.atlassian.plugins.authentication.sso.spring.JvmBeansConfiguration;
import com.atlassian.plugins.authentication.sso.spring.ValidatorConfiguration;
import com.atlassian.plugins.authentication.sso.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.sso.util.DefaultLicenseDataProvider;
import com.atlassian.plugins.authentication.sso.util.HttpsValidator;
import com.atlassian.plugins.authentication.sso.util.JsmUrlChecker;
import com.atlassian.plugins.authentication.sso.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerProvider;
import com.atlassian.plugins.authentication.sso.web.CookieService;
import com.atlassian.plugins.authentication.sso.web.SessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.SessionDataService;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.writer.DisableNativeLoginLegacyModeAuthResponseWriter;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.writer.DisableNativeLoginTwoStepVerificationAuthResponseWriter;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcAuthenticationHandler;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcAuthenticationRequestFactory;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcDiscoveryRefreshJob;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcDiscoverySupport;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcTimeouts;
import com.atlassian.plugins.authentication.sso.web.saml.SamlAssertionValidationService;
import com.atlassian.plugins.authentication.sso.web.saml.SamlAuthenticationHandler;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.SamlSpKeyCertificatePairService;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.SamlSpKeyCertificatePairStore;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.impl.CachingSamlSpKeyCertificatePairStore;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.impl.CertificateAndPrivateKeyGenerator;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.impl.FileBasedSamlSpKeyCertificatePairStore;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.impl.SamlSpKeyCertificatePairServiceImpl;
import com.atlassian.plugins.authentication.sso.web.saml.provider.SamlProvider;
import com.atlassian.plugins.authentication.sso.web.saml.provider.impl.OneloginJavaSamlProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.security.Provider;
import java.time.Clock;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonImportsConfiguration.class, BlockingBasicAuthConfiguration.class, DatabaseConfiguration.class, JvmBeansConfiguration.class, ConfigMapperConfiguration.class, ValidatorConfiguration.class})
public class SsoConfiguration {
    @Bean
    public OidcTimeouts oidcTimeouts() {
        return new OidcTimeouts();
    }

    @Bean
    public OidcDiscoverySupport oidcDiscoverySupport() {
        return new OidcDiscoverySupport(this.oidcTimeouts());
    }

    @Bean
    public ProductLicenseDataProvider productLicenseDataProvider(LicenseHandler licenseHandler) {
        return new DefaultLicenseDataProvider(licenseHandler);
    }

    @Bean
    public ApplicationStateValidator applicationStateValidator(HttpsValidator httpsValidator, ProductLicenseDataProvider productLicenseDataProvider) {
        return new ApplicationStateValidator(httpsValidator, productLicenseDataProvider);
    }

    @Bean
    public IdpConfigService idpConfigService(SsoConfigDao ssoConfigDao, IdpConfigValidatorProvider idpConfigValidatorProvider, OidcDiscoverySupport oidcDiscoverySupport, ProductLicenseDataProvider productLicenseDataProvider, ApplicationStateValidator applicationStateValidator, IdpConfigMappers idpConfigMappers, AuditService auditService) {
        return new AuditingIdpConfigService(ssoConfigDao, idpConfigValidatorProvider, oidcDiscoverySupport, productLicenseDataProvider, applicationStateValidator, idpConfigMappers, auditService);
    }

    @Bean
    public SsoConfigService ssoConfigService(EventPublisher eventPublisher, SsoConfigDao ssoConfigDao, SsoConfigValidator ssoConfigValidator, IdpConfigService idpConfigService, ProductLicenseDataProvider productLicenseDataProvider, ApplicationStateValidator applicationStateValidator, SsoConfigCachingService ssoConfigCachingService) {
        return new SsoConfigServiceImpl(eventPublisher, ssoConfigDao, ssoConfigValidator, idpConfigService, productLicenseDataProvider, applicationStateValidator, ssoConfigCachingService);
    }

    @Bean
    public LoginOptionsService loginOptionsService(SsoConfigService ssoConfigService, IdpConfigService idpConfigService, ApplicationProperties applicationProperties, ApplicationStateValidator applicationStateValidator, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        return new LoginOptionsServiceImpl(ssoConfigService, idpConfigService, applicationProperties, applicationStateValidator, authenticationPluginFeatureService);
    }

    @Bean
    public TargetUrlNormalizer targetUrlNormalizer(ApplicationProperties applicationProperties) {
        return new TargetUrlNormalizer(applicationProperties);
    }

    @Bean
    public JsmUrlChecker jsmUrlChecker(ApplicationProperties applicationProperties, TargetUrlNormalizer targetUrlNormalizer) {
        return new JsmUrlChecker(applicationProperties, targetUrlNormalizer);
    }

    @Bean
    public LoginGatewayDataProvider loginGatewayDataProvider(ApplicationProperties applicationProperties, JsmUrlChecker jsmUrlChecker, ProductLoginPageDataServiceFactory productLoginPageDataServiceFactory) {
        return new LoginGatewayDataProvider(applicationProperties, jsmUrlChecker, productLoginPageDataServiceFactory);
    }

    @Bean
    public IdpsResourceService idpsResourceService(IdpConfigService idpConfigService, ApplicationStateValidator applicationStateValidator) {
        return new IdpsResourceService(idpConfigService, applicationStateValidator);
    }

    @Bean
    public JitProvisionedUsersResourceService jitProvisionedUsersResourceService(CrowdService crowdService) {
        return new JitProvisionedUsersResourceService(crowdService);
    }

    @Bean
    public SsoConfigResourceService ssoConfigResourceService(SsoConfigService ssoConfigService) {
        return new SsoConfigResourceService(ssoConfigService);
    }

    @Bean
    public SamlProvider samlProvider(SamlSpKeyCertificatePairService samlSpKeyCertificatePairService, AuthenticationPluginFeatureInternalService authenticationPluginFeatureInternalService) {
        return new OneloginJavaSamlProvider(samlSpKeyCertificatePairService, authenticationPluginFeatureInternalService);
    }

    @Bean
    public CookieService cookieService(ApplicationProperties applicationProperties) {
        return new CookieService(applicationProperties);
    }

    @Bean
    public SessionDataService sessionDataService(CookieService cookieService, ApplicationProperties applicationProperties, SessionDataCacheFactory sessionDataCacheFactory) {
        return new SessionDataService(cookieService, applicationProperties, sessionDataCacheFactory);
    }

    @Bean
    public SamlAuthenticationHandler samlAuthenticationHandler(ApplicationProperties applicationProperties, ApplicationStateValidator applicationStateValidator, SamlProvider samlProvider, SessionDataService sessionDataService, SoyTemplateRenderer soyTemplateRenderer, WebResourceUrlProvider webResourceUrlProvider, TargetUrlNormalizer targetUrlNormalizer) {
        return new SamlAuthenticationHandler(applicationProperties, applicationStateValidator, samlProvider, sessionDataService, soyTemplateRenderer, webResourceUrlProvider, targetUrlNormalizer);
    }

    @Bean
    public SamlSpKeyCertificatePairService samlSpKeyCertificatePairService(CertificateAndPrivateKeyGenerator certificateAndPrivateKeyGenerator, SamlSpKeyCertificatePairStore samlSpKeyCertificatePairStore) {
        return new SamlSpKeyCertificatePairServiceImpl(certificateAndPrivateKeyGenerator, samlSpKeyCertificatePairStore);
    }

    @Bean
    public OidcAuthenticationRequestFactory oidcAuthenticationRequestFactory(ApplicationProperties applicationProperties) {
        return new OidcAuthenticationRequestFactory(applicationProperties);
    }

    @Bean
    public OidcAuthenticationHandler oidcAuthenticationHandler(ApplicationProperties applicationProperties, ApplicationStateValidator applicationStateValidator, SessionDataService sessionDataService, OidcAuthenticationRequestFactory oidcAuthenticationRequestFactory, TargetUrlNormalizer targetUrlNormalizer, WebResourceUrlProvider webResourceUrlProvider, SoyTemplateRenderer soyTemplateRenderer) {
        return new OidcAuthenticationHandler(applicationProperties, applicationStateValidator, sessionDataService, oidcAuthenticationRequestFactory, targetUrlNormalizer, webResourceUrlProvider, soyTemplateRenderer);
    }

    @Bean
    public AuthenticationHandlerProvider authenticationHandlerProvider(SamlAuthenticationHandler samlAuthenticationHandler, OidcAuthenticationHandler oidcAuthenticationHandler) {
        return new AuthenticationHandlerProvider(samlAuthenticationHandler, oidcAuthenticationHandler);
    }

    @Bean
    public OidcDiscoveryRefreshJob oidcDiscoveryRefreshJob(SchedulerService schedulerService, SsoConfigService ssoConfigService, IdpConfigService idpConfigService, EventPublisher eventPublisher) {
        return new OidcDiscoveryRefreshJob(schedulerService, ssoConfigService, idpConfigService, eventPublisher);
    }

    @Bean
    public SamlAssertionValidationService samlAssertionValidationService(SeenAssertionDao seenAssertionDao, SchedulerService schedulerService) {
        return new SamlAssertionValidationService(seenAssertionDao, schedulerService);
    }

    @Bean
    public SsoConfigCachingService ssoConfigCachingService(CacheManager cacheManager, SsoConfigDao ssoConfigDao) {
        return new HybridSsoConfigCache(cacheManager, ssoConfigDao);
    }

    @Bean
    public DisableNativeLoginLegacyModeAuthResponseWriter disableLegacyModeLoginFormResponseWriter(I18nResolver i18nResolver) {
        return new DisableNativeLoginLegacyModeAuthResponseWriter(i18nResolver);
    }

    @Bean
    public DisableNativeLoginTwoStepVerificationAuthResponseWriter disableLoginFormResponseWriter(I18nResolver i18nResolver) {
        return new DisableNativeLoginTwoStepVerificationAuthResponseWriter(i18nResolver);
    }

    @Bean
    public BouncyCastleProvider bouncyCastleProvider() {
        return new BouncyCastleProvider();
    }

    @Bean
    public CertificateAndPrivateKeyGenerator certificateAndPrivateKeyGenerator(Clock clock) {
        return new CertificateAndPrivateKeyGenerator(clock, (Provider)this.bouncyCastleProvider());
    }

    @Bean
    public SamlSpKeyCertificatePairStore keyCertificatePairUtils(EncryptionConfigurationService encryptionConfigurationService, CacheManager cacheManager, ClusterLockService clusterLockService) {
        return new CachingSamlSpKeyCertificatePairStore(new FileBasedSamlSpKeyCertificatePairStore((Provider)this.bouncyCastleProvider(), encryptionConfigurationService), cacheManager, clusterLockService);
    }
}

