/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.ui.login;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.authentication.sso.data.LoginGatewayDataProvider;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.util.SafeBasePathUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.gson.Gson;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class LoginGatewayServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LoginGatewayServlet.class);
    private static final Gson GSON = new Gson();
    public static final String URL = "/plugins/servlet/login";
    @VisibleForTesting
    protected static final String TEMPLATE_NAME = "AuthenticationPlugin.LoginPage.display";
    @VisibleForTesting
    protected static final String[] ATTRIBUTES_WHEN_FORWARDED_TO_SERVLET = new String[]{"jakarta.servlet.forward.request_uri"};
    private static final String PERMISSION_VIOLATION = "permissionViolation";
    private final ApplicationProperties applicationProperties;
    private final PageBuilderService pageBuilderService;
    private final SoyTemplateRenderer renderer;
    private final LoginGatewayDataProvider loginGatewayDataProvider;
    private final UserManager userManager;
    private final TargetUrlNormalizer targetUrlNormalizer;

    public LoginGatewayServlet(SoyTemplateRenderer renderer, LoginGatewayDataProvider loginGatewayDataProvider, ApplicationProperties applicationProperties, PageBuilderService pageBuilderService, UserManager userManager, TargetUrlNormalizer targetUrlNormalizer) {
        this.renderer = renderer;
        this.loginGatewayDataProvider = loginGatewayDataProvider;
        this.applicationProperties = applicationProperties;
        this.pageBuilderService = pageBuilderService;
        this.userManager = userManager;
        this.targetUrlNormalizer = targetUrlNormalizer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        String refererUrl = this.getRefererUrlFromTheRequest(request);
        String relativeBaseUrl = SafeBasePathUtil.getRelativeBaseUrl(this.applicationProperties);
        String homepageUrl = SafeBasePathUtil.getBaseRedirectPath(this.applicationProperties, relativeBaseUrl);
        if (refererUrl == null) {
            log.trace("Direct request made to login gateway, redirecting to application base URL.");
            response.sendRedirect(homepageUrl);
            return;
        }
        boolean isLoggedIn = this.userManager.getRemoteUserKey() != null;
        Object destinationAttribute = request.getAttribute("atlassian.plugin.auth.destination");
        Optional<String> maybeRequestedRelativeDestinationUrl = Optional.ofNullable(destinationAttribute).map(Object::toString).map(this.targetUrlNormalizer::getRelativeTargetUrl).map(URI::toString);
        if (isLoggedIn && this.shouldNotShowLoginPage(request)) {
            log.trace("User is already logged in or login page should not be shown, redirecting to application base URL.");
            String targetUrl = maybeRequestedRelativeDestinationUrl.map(requestedRelativeDestinationUrl -> StringUtils.removeEnd((String)relativeBaseUrl, (String)"/") + StringUtils.prependIfMissing((String)requestedRelativeDestinationUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0])).orElse(homepageUrl);
            response.sendRedirect(targetUrl);
            return;
        }
        if (this.applicationProperties.getPlatformId().equals("crowd") && maybeRequestedRelativeDestinationUrl.isPresent() && maybeRequestedRelativeDestinationUrl.get().startsWith("/console/secure/saml/sso.action")) {
            request.getSession(true).setAttribute("SPRING_SECURITY_CROWD_RENDERED_LOGIN_PAGE", (Object)true);
        }
        Map<String, Object> dataMap = this.loginGatewayDataProvider.getMap(request, refererUrl, maybeRequestedRelativeDestinationUrl.orElse(null));
        this.pageBuilderService.assembler().data().requireData("com.atlassian.plugins.authentication.atlassian-authentication-plugin:login-gateway-data", writer -> GSON.toJson((Object)dataMap, (Appendable)writer));
        this.renderer.render((Appendable)response.getWriter(), "com.atlassian.plugins.authentication.atlassian-authentication-plugin:templates", TEMPLATE_NAME, dataMap);
    }

    private boolean shouldNotShowLoginPage(HttpServletRequest request) {
        boolean isPermissionViolation = request.getParameter(PERMISSION_VIOLATION) != null;
        boolean isNativeLoginRequested = request.getParameter("native_login") != null;
        log.trace("Checking if login page should be skipped - permission violation status: {}, native login requested: {}", (Object)isPermissionViolation, (Object)isNativeLoginRequested);
        if (this.applicationProperties.getPlatformId().equals("crowd")) {
            boolean forceAuthnValue = Boolean.parseBoolean(request.getParameter("forceAuthn"));
            log.trace("Checking if login page should be skipped - forceAuthn status: {}", (Object)forceAuthnValue);
            return !isPermissionViolation && !isNativeLoginRequested && !forceAuthnValue;
        }
        return !isPermissionViolation && !isNativeLoginRequested;
    }

    private String getRefererUrlFromTheRequest(HttpServletRequest request) {
        for (String attributeName : ATTRIBUTES_WHEN_FORWARDED_TO_SERVLET) {
            String url = (String)request.getAttribute(attributeName);
            if (url == null) continue;
            return url;
        }
        return null;
    }
}

