/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.util;

import com.atlassian.confluence.plugin.descriptor.web.conditions.BuildNumberCondition;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.BuildNumberRangeChecker;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ConfluenceBuildNumberCondition {
    private final BootstrapManager bootstrapManager;
    private final BuildNumberRangeChecker rangeChecker;

    public ConfluenceBuildNumberCondition(BootstrapManager bootstrapManager, BuildNumberRangeChecker rangeChecker) {
        this.bootstrapManager = bootstrapManager;
        this.rangeChecker = rangeChecker;
    }

    public final boolean isPost(Integer minBuildNum) {
        return this.matchesRange(minBuildNum, null);
    }

    public final boolean matchesRange(@Nullable Integer minBuildNum, @Nullable Integer maxBuildNum) {
        HashMap<String, String> range = new HashMap<String, String>();
        Optional.ofNullable(minBuildNum).ifPresent(min -> range.put("minBuildNumber", min.toString()));
        Optional.ofNullable(maxBuildNum).ifPresent(max -> range.put("maxBuildNumber", max.toString()));
        return this.matchesExpectedBuildNumRange(range);
    }

    private boolean matchesExpectedBuildNumRange(Map<String, String> range) {
        BuildNumberCondition condition = new BuildNumberCondition();
        condition.setBootstrapManager(this.bootstrapManager);
        condition.setBuildNumberRangeChecker(this.rangeChecker);
        condition.init(range);
        return condition.shouldDisplay(Collections.emptyMap());
    }
}

