/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.util;

import com.atlassian.plugins.authentication.sso.util.ProductLicenseDataProvider;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLicenseDataProvider
implements ProductLicenseDataProvider {
    public static final String JSM_LEGACY_ACTIVE_PROPERTY_KEY = "com.atlassian.servicedesk.active";
    public static final String JSM_RBP_ACTIVE_PROPERTY_KEY = "jira.product.jira-servicedesk.active";
    private static final Logger log = LoggerFactory.getLogger(DefaultLicenseDataProvider.class);
    private final Predicate<MultiProductLicenseDetails> dataCenterPredicate = BaseLicenseDetails::isDataCenter;
    private final Predicate<MultiProductLicenseDetails> serviceManagementPredicate = license -> Boolean.parseBoolean(license.getProperty(JSM_LEGACY_ACTIVE_PROPERTY_KEY)) || Boolean.parseBoolean(license.getProperty(JSM_RBP_ACTIVE_PROPERTY_KEY));
    private LicenseHandler licenseHandler;

    public DefaultLicenseDataProvider(LicenseHandler licenseHandler) {
        this.licenseHandler = licenseHandler;
    }

    @Override
    public boolean isDataCenterProduct() {
        return this.licenseHandler.getAllProductLicenses().stream().allMatch(this.dataCenterPredicate);
    }

    @Override
    public boolean isServiceManagementProduct() {
        try {
            return this.licenseHandler.getAllProductLicenses().stream().anyMatch(this.serviceManagementPredicate);
        }
        catch (Exception e) {
            log.debug("Exception caught when checking if JSM license exists", (Throwable)e);
            return false;
        }
    }
}

