/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.util;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetUrlNormalizer {
    private static final Logger log = LoggerFactory.getLogger(TargetUrlNormalizer.class);
    private static final Set<String> ILLEGAL_DESTINATION_URLS = ImmutableSet.of((Object)"/plugins/servlet/samlconsumer", (Object)"/plugins/servlet/sso-logout", (Object)"/plugins/servlet/oidc/initiate-login");
    protected final ApplicationProperties applicationProperties;
    @VisibleForTesting
    protected static final String PATH_PREFIX = "/a345/b342/c5462/";

    public TargetUrlNormalizer(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Nullable
    public URI getRelativeTargetUrl(String targetUrl) {
        if (targetUrl != null) {
            try {
                URI normalizedUri = new URI(targetUrl.replace(" ", "+")).normalize();
                URI relativizedAndNormalizedUri = this.relativizeUriIfNeeded(normalizedUri);
                String path = relativizedAndNormalizedUri.getPath();
                this.validatePathTraversal(targetUrl, path);
                if (!ILLEGAL_DESTINATION_URLS.contains(path) && !relativizedAndNormalizedUri.toString().isEmpty()) {
                    return relativizedAndNormalizedUri;
                }
                log.debug("Requested destination url {} is not an allowed destination url, continuing without a destination url ", (Object)targetUrl);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Error parsing provided url " + targetUrl + ", aborting", e);
            }
        }
        return null;
    }

    public URI removeContextPathFromUriIfNeeded(URI targetUri) {
        String contextPath = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        String urlAsString = targetUri.toString();
        if (urlAsString.startsWith(contextPath)) {
            return UriBuilder.fromUri((String)urlAsString.substring(contextPath.length())).build(new Object[0]);
        }
        return targetUri;
    }

    private URI relativizeUriIfNeeded(URI targetUri) throws URISyntaxException {
        boolean shouldRelativize;
        String contextPath = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        String uriAsString = targetUri.toString();
        boolean bl = shouldRelativize = targetUri.isAbsolute() || Strings.emptyToNull((String)targetUri.getHost()) != null || targetUri.getPort() != -1 || Strings.emptyToNull((String)targetUri.getUserInfo()) != null || Strings.emptyToNull((String)targetUri.getAuthority()) != null || uriAsString.startsWith(contextPath);
        if (shouldRelativize) {
            URI relativizedUrl = UriBuilder.fromUri((String)"").replacePath(targetUri.getPath()).replaceQuery(targetUri.getRawQuery()).fragment(targetUri.getFragment()).build(new Object[0]);
            return this.removeContextPathFromUriIfNeeded(relativizedUrl);
        }
        return targetUri;
    }

    private void validatePathTraversal(String targetUrl, String path) {
        Preconditions.checkArgument((boolean)UriBuilder.fromPath((String)PATH_PREFIX).path(path).build(new Object[0]).normalize().getPath().startsWith(PATH_PREFIX), (Object)("Requested path traversal outside the context path " + targetUrl + ", aborting"));
    }
}

