/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web;

import com.atlassian.plugins.authentication.api.config.SsoType;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerNotConfiguredException;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcAuthenticationHandler;
import com.atlassian.plugins.authentication.sso.web.saml.SamlAuthenticationHandler;
import jakarta.annotation.Nonnull;

public class AuthenticationHandlerProvider {
    private final SamlAuthenticationHandler samlAuthenticationHandler;
    private final OidcAuthenticationHandler oidcAuthenticationHandler;

    public AuthenticationHandlerProvider(SamlAuthenticationHandler samlAuthenticationHandler, OidcAuthenticationHandler oidcAuthenticationHandler) {
        this.samlAuthenticationHandler = samlAuthenticationHandler;
        this.oidcAuthenticationHandler = oidcAuthenticationHandler;
    }

    @Nonnull
    public AuthenticationHandler getAuthenticationHandler(@Nonnull SsoType ssoType) {
        switch (ssoType) {
            case SAML: {
                return this.samlAuthenticationHandler;
            }
            case OIDC: {
                return this.oidcAuthenticationHandler;
            }
        }
        throw new AuthenticationHandlerNotConfiguredException("Can't provide authentication handler for SSO type: " + String.valueOf(ssoType));
    }
}

