/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.authentication.api.config.IdpConfig;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.sso.config.IdpNotFoundException;
import com.atlassian.plugins.authentication.sso.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerProvider;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class LoginServlet
extends HttpServlet {
    public static final String URL = "/plugins/servlet/external-login";
    private final Logger log = LoggerFactory.getLogger(LoginServlet.class);
    private final AuthenticationHandlerProvider authenticationHandlerProvider;
    private final IdpConfigService idpConfigService;
    private final I18nResolver i18nResolver;
    private final ProductLicenseDataProvider productLicenseDataProvider;

    public LoginServlet(AuthenticationHandlerProvider authenticationHandlerProvider, IdpConfigService idpConfigService, I18nResolver i18nResolver, ProductLicenseDataProvider productLicenseDataProvider) {
        this.authenticationHandlerProvider = authenticationHandlerProvider;
        this.idpConfigService = idpConfigService;
        this.i18nResolver = i18nResolver;
        this.productLicenseDataProvider = productLicenseDataProvider;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            long idpId = this.extractIdpIdPathParam(req);
            IdpConfig idpConfig = this.idpConfigService.getIdpConfig(Long.valueOf(idpId));
            if (idpConfig == null || this.isIdpDisabled(idpConfig)) {
                this.log.error("External login request: could not find enabled IDP configuration with ID '{}'", (Object)idpId);
                throw new IdpNotFoundException(idpId);
            }
            this.authenticationHandlerProvider.getAuthenticationHandler(idpConfig.getSsoType()).processAuthenticationRequest(req, resp, this.extractDestinationParam(req).orElse(null), idpConfig);
        }
        catch (IllegalArgumentException e) {
            resp.sendError(400, e.getMessage());
        }
    }

    private boolean isIdpDisabled(IdpConfig idpConfig) {
        return !idpConfig.isEnabled() && this.isIdpDisabledInJsm(idpConfig);
    }

    private boolean isIdpDisabledInJsm(IdpConfig idpConfig) {
        return !this.productLicenseDataProvider.isServiceManagementProduct() || !idpConfig.isIncludeCustomerLogins();
    }

    private long extractIdpIdPathParam(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            this.log.error("External login request is missing IDP ID path param");
            throw new IllegalArgumentException("Identity Provider ID was not provided in request path");
        }
        String[] pathParts = pathInfo.split("/");
        if (pathParts.length == 2) {
            return this.parseIdpIdParam(pathParts[1]);
        }
        this.log.error("External login request has unexpected path params: {}", (Object)pathInfo);
        throw new IllegalArgumentException("Unexpected path parameters in request");
    }

    private long parseIdpIdParam(String param) {
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException exception) {
            this.log.error("External login request IDP ID param not parsable to Long. Was '{}'", (Object)param);
            throw new IllegalArgumentException("Invalid Identity Provider ID path parameter");
        }
    }

    private Optional<String> extractDestinationParam(HttpServletRequest req) {
        return Optional.ofNullable(req.getParameter("authDest"));
    }
}

