/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.authentication;

import com.atlassian.plugins.authentication.api.config.IdpConfig;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.IdpLoginOption;
import com.atlassian.plugins.authentication.api.config.LegacyLoginFormLoginOption;
import com.atlassian.plugins.authentication.api.config.LoginGatewayType;
import com.atlassian.plugins.authentication.api.config.LoginOption;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerProvider;
import com.atlassian.plugins.authentication.sso.web.exception.UnsupportedHttpMethodException;
import com.atlassian.plugins.authentication.sso.web.filter.AbstractJohnsonAwareFilter;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nullable;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticationFilter
extends AbstractJohnsonAwareFilter {
    public static final String DESTINATION_REQUEST_PARAM = "atlassian.plugin.auth.destination";
    static final String SITEMESH_ALREADY_FILTERED_ATTRIBUTE_NAME = "com.atlassian.prettyurls.filter.PrettyUrlsSiteMeshFilter";
    protected final Logger log = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String AUTH_FALLBACK_QUERY_PARAM = "auth_fallback";
    public static final String ATLASSIAN_RECOVERY_PASSWORD = "atlassian.recovery.password";
    public static final String NATIVE_LOGIN_PARAM = "native_login";
    protected final AuthenticationHandlerProvider authenticationHandlerProvider;
    protected final IdpConfigService idpConfigService;
    protected final LoginOptionsService loginOptionsService;
    protected final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;

    public AuthenticationFilter(AuthenticationHandlerProvider authenticationHandlerProvider, IdpConfigService idpConfigService, LoginOptionsService loginOptionsService, JohnsonChecker johnsonChecker, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        super(johnsonChecker);
        this.authenticationHandlerProvider = authenticationHandlerProvider;
        this.idpConfigService = idpConfigService;
        this.loginOptionsService = loginOptionsService;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
    }

    @Override
    protected void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            boolean authFallbackParamPresent = this.isAuthFallbackParamPresent(httpRequest);
            List loginOptions = this.loginOptionsService.getLoginOptions(authFallbackParamPresent, this.getLoginGatewayType());
            if (this.isForcingNativeLogin(authFallbackParamPresent, loginOptions, httpRequest)) {
                this.renderProperLoginPageBasedOnSystemProperty(httpRequest, httpResponse, chain);
            } else if (this.isProductInRecoveryMode()) {
                this.log.trace("Not attempting external authentication, Atlassian password recovery set");
                this.renderProperLoginPageBasedOnSystemProperty(httpRequest, httpResponse, chain);
            } else if (this.isProductSpecificSkip(loginOptions, httpRequest)) {
                this.log.warn("Skipping because of product specific configuration");
                chain.doFilter(request, response);
            } else if (this.isSupportedHttpMethod(httpRequest)) {
                if (loginOptions.size() == 1) {
                    this.handleSingleLoginOption(chain, httpRequest, httpResponse, (LoginOption)Iterables.getOnlyElement((Iterable)loginOptions));
                } else {
                    this.continueToLoginGateway(httpRequest, httpResponse);
                }
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (UnsupportedHttpMethodException e) {
            this.log.warn(httpRequest.getMethod() + " method is not supported, thus sending '303 See Other' redirect");
            this.httpResponseSendSeeOtherRedirect(httpRequest, httpResponse);
        }
        catch (IllegalArgumentException e) {
            httpResponse.sendError(Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage());
        }
    }

    private void continueToLoginGateway(HttpServletRequest httpRequest, HttpServletResponse response) throws ServletException, IOException {
        this.log.trace("Redirecting to login gateway");
        this.forceSitemeshToProcessRequest(httpRequest);
        this.saveRequestedUrl(httpRequest, this.extractRequestedUrl(httpRequest));
        httpRequest.getRequestDispatcher("/plugins/servlet/login").forward((ServletRequest)httpRequest, (ServletResponse)response);
    }

    private void renderProperLoginPageBasedOnSystemProperty(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws ServletException, IOException {
        if (this.authenticationPluginFeatureService.isLegacyModeEnabled()) {
            this.continueToNativeLoginForm(chain, httpRequest, httpResponse);
        } else {
            this.continueToLoginGateway(httpRequest, httpResponse);
        }
    }

    protected boolean isProductSpecificSkip(List<LoginOption> loginOptions, HttpServletRequest httpRequest) {
        return false;
    }

    private boolean isForcingNativeLogin(boolean authFallbackParamPresent, List<LoginOption> loginOptions, HttpServletRequest request) {
        return loginOptions.contains(LegacyLoginFormLoginOption.INSTANCE) && (authFallbackParamPresent || this.isNativeLoginRequested(request));
    }

    private void handleSingleLoginOption(FilterChain chain, HttpServletRequest httpRequest, HttpServletResponse httpResponse, LoginOption loginOption) throws IOException, ServletException {
        switch (loginOption.getType()) {
            case LOGIN_FORM: {
                this.continueToLoginGateway(httpRequest, httpResponse);
                return;
            }
            case LEGACY_LOGIN_FORM: {
                this.continueToNativeLoginForm(chain, httpRequest, httpResponse);
                return;
            }
            case IDP: {
                this.handleIdpLogin((IdpLoginOption)loginOption, chain, httpRequest, httpResponse);
                return;
            }
        }
        throw new IllegalStateException("Doesnt support this login type " + String.valueOf(loginOption.getType()));
    }

    private void continueToNativeLoginForm(FilterChain chain, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        this.log.trace("Not attempting external authentication, native login is the only option");
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    protected boolean isSupportedHttpMethod(HttpServletRequest httpRequest) {
        return httpRequest.getMethod().equals("GET");
    }

    private void handleIdpLogin(IdpLoginOption idpLoginOption, FilterChain chain, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        IdpConfig idpConfig = this.idpConfigService.getIdpConfig(Long.valueOf(idpLoginOption.getId()));
        AuthenticationHandler authenticationHandler = this.authenticationHandlerProvider.getAuthenticationHandler(idpConfig.getSsoType());
        if (authenticationHandler.isCorrectlyConfigured(idpConfig)) {
            this.log.trace("Redirecting to external IDP login page for idp (id='{}', name='{}') as it is the only available login option", (Object)idpConfig.getId(), (Object)idpConfig.getName());
            authenticationHandler.processAuthenticationRequest(httpRequest, httpResponse, this.extractRequestedUrl(httpRequest), idpConfig);
        } else {
            this.log.trace("External IdP (id='{}', name='{}') is not correctly configured, continuing to product login page", (Object)idpConfig.getId(), (Object)idpConfig.getName());
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    private boolean isProductInRecoveryMode() {
        return System.getProperty(ATLASSIAN_RECOVERY_PASSWORD) != null;
    }

    private boolean isNativeLoginRequested(HttpServletRequest request) {
        return request.getParameter(NATIVE_LOGIN_PARAM) != null;
    }

    private void forceSitemeshToProcessRequest(HttpServletRequest req) {
        req.removeAttribute(SITEMESH_ALREADY_FILTERED_ATTRIBUTE_NAME);
    }

    private void saveRequestedUrl(HttpServletRequest req, String url) {
        req.setAttribute(DESTINATION_REQUEST_PARAM, (Object)url);
    }

    private boolean isAuthFallbackParamPresent(HttpServletRequest request) {
        return request.getParameter(AUTH_FALLBACK_QUERY_PARAM) != null;
    }

    @Nullable
    protected abstract String extractRequestedUrl(HttpServletRequest var1);

    protected LoginGatewayType getLoginGatewayType() {
        return LoginGatewayType.GLOBAL_LOGIN_GATEWAY;
    }

    private void httpResponseSendSeeOtherRedirect(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        httpResponse.setStatus(Response.Status.SEE_OTHER.getStatusCode());
        httpResponse.setHeader("Location", httpRequest.getRequestURI());
        httpResponse.flushBuffer();
    }
}

