/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.authentication;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.web.Cookies;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ConfluenceLanguageSupportFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceLanguageSupportFilter.class);
    private final LocaleManager localeManager;
    private final LanguageManager languageManager;

    public ConfluenceLanguageSupportFilter(LocaleManager localeManager, LanguageManager languageManager) {
        this.localeManager = localeManager;
        this.languageManager = languageManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getParameter("language") != null) {
            String language = request.getParameter("language");
            if (this.languageManager.getLanguage(language) != null) {
                log.debug("Setting request language to {} based on request parameter", (Object)language);
                this.localeManager.setLanguage(language);
                Cookies.setResponseCookie((String)"confluence-language", (String)language);
            }
        } else {
            log.debug("Using default language");
        }
        chain.doFilter(request, response);
    }
}

