/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.loginform;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.authentication.api.config.SsoConfig;
import com.atlassian.plugins.authentication.api.config.SsoConfigCachingService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.web.filter.AbstractJohnsonAwareFilter;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.checker.DisabledNativeLoginRequestBlockingChecker;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.writer.DisableNativeLoginLegacyModeAuthResponseWriter;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.writer.DisableNativeLoginTwoStepVerificationAuthResponseWriter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class DisableNativeLoginAuthFilter
extends AbstractJohnsonAwareFilter {
    private static final Logger log = LoggerFactory.getLogger(DisableNativeLoginAuthFilter.class);
    private final DisableNativeLoginLegacyModeAuthResponseWriter legacyModeEnabledResponseWriter;
    private final DisableNativeLoginTwoStepVerificationAuthResponseWriter twoStepVerificationAuthResponseWriter;
    private final List<DisabledNativeLoginRequestBlockingChecker> blockRequestChecks;
    protected final SsoConfigCachingService ssoConfigCachingService;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;

    public DisableNativeLoginAuthFilter(JohnsonChecker johnsonChecker, DisableNativeLoginLegacyModeAuthResponseWriter legacyModeEnabledResponseWriter, DisableNativeLoginTwoStepVerificationAuthResponseWriter twoStepVerificationAuthResponseWriter, List<DisabledNativeLoginRequestBlockingChecker> blockRequestChecks, SsoConfigCachingService ssoConfigCachingService, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        super(johnsonChecker);
        this.legacyModeEnabledResponseWriter = legacyModeEnabledResponseWriter;
        this.twoStepVerificationAuthResponseWriter = twoStepVerificationAuthResponseWriter;
        this.blockRequestChecks = blockRequestChecks;
        this.ssoConfigCachingService = ssoConfigCachingService;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
    }

    @Override
    public void doFilterInternal(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        Result result = this.shouldBlock(request);
        switch (result.resultType.ordinal()) {
            case 0: {
                log.trace("Blocking HTTP request - Native Login is not allowed: {}", (Object)request.getRequestURI());
                this.legacyModeEnabledResponseWriter.write(request, response, result.errorStatusCode);
                break;
            }
            case 1: {
                log.trace("Blocking HTTP request - Native Login is not allowed as new login form with two-step verification capability is enabled: {}", (Object)request.getRequestURI());
                this.twoStepVerificationAuthResponseWriter.write(request, response, result.errorStatusCode);
                break;
            }
            case 2: {
                log.trace("Allowing HTTP request: {}", (Object)request.getRequestURI());
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                break;
            }
            default: {
                log.trace("Allowing HTTP request - Invalid Result value. URI : {}, Result : {}", (Object)request.getRequestURI(), (Object)result.resultType);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected Result shouldBlock(HttpServletRequest request) {
        boolean isLegacyModeEnabled = this.authenticationPluginFeatureService.isLegacyModeEnabled();
        boolean isNativeAuthenticationRequest = this.isNativeAuthenticationRequest(request);
        boolean isRecoverModeEnabled = this.isProductInRecoveryMode();
        NativeLoginContext nativeLoginContext = this.isNativeLoginEnabled(request);
        if (isLegacyModeEnabled && !isRecoverModeEnabled && !nativeLoginContext.isNativeLoginEnabled && isNativeAuthenticationRequest) {
            return new Result(ResultType.BLOCK_REQUEST_LEGACY_ENABLED, nativeLoginContext.errorStatusCode);
        }
        if (!isLegacyModeEnabled && isNativeAuthenticationRequest) {
            return new Result(ResultType.BLOCK_REQUEST_LEGACY_DISABLED, nativeLoginContext.errorStatusCode);
        }
        return new Result(ResultType.ALLOW_REQUEST, nativeLoginContext.errorStatusCode);
    }

    protected boolean isNativeAuthenticationRequest(HttpServletRequest request) {
        return this.blockRequestChecks.stream().anyMatch(check -> check.test(request));
    }

    protected NativeLoginContext isNativeLoginEnabled(HttpServletRequest request) {
        return new NativeLoginContext(this.isNativeLoginEnabled(SsoConfig::getShowLoginForm), Response.Status.FORBIDDEN);
    }

    protected boolean isNativeLoginEnabled(Predicate<SsoConfig> showLoginForm) {
        SsoConfig ssoConfig = this.ssoConfigCachingService.get();
        return showLoginForm.test(ssoConfig) || ssoConfig.enableAuthenticationFallback();
    }

    private boolean isProductInRecoveryMode() {
        return System.getProperty("atlassian.recovery.password") != null;
    }

    record Result(ResultType resultType, Response.Status errorStatusCode) {
    }

    static enum ResultType {
        BLOCK_REQUEST_LEGACY_ENABLED,
        BLOCK_REQUEST_LEGACY_DISABLED,
        ALLOW_REQUEST;

    }

    record NativeLoginContext(boolean isNativeLoginEnabled, Response.Status errorStatusCode) {
    }
}

