/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.loginpage;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageData;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;

public class BambooProductLoginPageDataService
implements ProductLoginPageDataService {
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final ApplicationProperties applicationProperties;
    private static final String SIGNUP_PATH = "doSignupUser.action";
    private static final String FORGET_PASSWORD_PATH = "forgotPassword.action";

    public BambooProductLoginPageDataService(AdministrationConfigurationAccessor administrationConfigurationAccessor, ApplicationProperties applicationProperties) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public ProductLoginPageData getLoginPageData(HttpServletRequest httpServletRequest) {
        return ProductLoginPageData.builder().setSignupUrl(this.getSignUpUrl()).setForgotPasswordUrl(this.getForgetPasswordUrl()).setRememberMeType(ProductLoginPageData.RememberMeType.SHOW_UNCHECKED).setRecoveryModeContext(null).setShowLogo(false).setAuthenticationByEmail(false).build();
    }

    @Nullable
    private String getSignUpUrl() {
        if (this.administrationConfigurationAccessor.getAdministrationConfiguration().isEnableSignup()) {
            return UrlUtils.appendSlashIfDoesntExist((String)this.applicationProperties.getBaseUrl(UrlMode.RELATIVE)) + SIGNUP_PATH;
        }
        return null;
    }

    @Nonnull
    private String getForgetPasswordUrl() {
        return UrlUtils.appendSlashIfDoesntExist((String)this.applicationProperties.getBaseUrl(UrlMode.RELATIVE)) + FORGET_PASSWORD_PATH;
    }
}

