/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.saml.certificate.impl;

import com.atlassian.plugins.authentication.sso.rest.model.KeyCertificatePair;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateAndPrivateKeyGenerator {
    private final Clock clock;
    private final Provider securityProvider;
    private static final String ALGORITHM_NAME = "RSA";
    private static final int CERTIFICATE_VALIDITY_IN_YEARS = 10;
    private static final String SIGNATURE_ALGORITHM = "SHA256WITHRSA";
    private static final String COMMON_NAME = "CN=Atlassian";
    private static final int KEY_SIZE = 4096;

    public CertificateAndPrivateKeyGenerator(Clock clock, Provider securityProvider) {
        this.clock = clock;
        this.securityProvider = securityProvider;
    }

    public KeyCertificatePair generateCertificateAndPrivateKey() {
        try {
            KeyPair keyPair = this.generateKeyPair(this.securityProvider);
            X509CertificateHolder certificateHolder = this.generateCertificate(this.securityProvider, keyPair);
            X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certificateHolder);
            return new KeyCertificatePair(keyPair.getPrivate(), certificate);
        }
        catch (NoSuchAlgorithmException | CertificateException | OperatorCreationException e) {
            throw new RuntimeException("Error while generating certificate", e);
        }
    }

    private KeyPair generateKeyPair(Provider provider) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM_NAME, provider);
        keyPairGenerator.initialize(4096);
        return keyPairGenerator.generateKeyPair();
    }

    private X509CertificateHolder generateCertificate(Provider provider, KeyPair keyPair) throws OperatorCreationException {
        ZonedDateTime now = ZonedDateTime.ofInstant(this.clock.instant(), ZoneId.systemDefault());
        Date createdDate = Date.from(now.toInstant());
        Date expirationDate = Date.from(now.plusYears(10L).toInstant());
        ContentSigner contentSigner = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(provider).build(keyPair.getPrivate());
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        X509v1CertificateBuilder certificateBuilder = new X509v1CertificateBuilder(new X500Name(COMMON_NAME), BigInteger.ONE, createdDate, expirationDate, new X500Name(COMMON_NAME), subjectPublicKeyInfo);
        return certificateBuilder.build(contentSigner);
    }
}

