/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.usercontext.impl.embeddedcrowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.plugins.authentication.sso.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.sso.web.usercontext.PrincipalResolver;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedCrowdPrincipalResolver
implements PrincipalResolver {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCrowdPrincipalResolver.class);
    private final AuthenticationController authenticationController;
    private final CrowdService crowdService;
    private final UserManager userManager;
    private final DarkFeatureManager darkFeatureManager;
    protected static final String EXTERNAL_DIRECTORY_FAILURE_HANDLING_FEATURE_KEY = "atlassian.authentication.sso.fallback.to.cached.user.when.operation.failed";

    public EmbeddedCrowdPrincipalResolver(AuthenticationController authenticationController, CrowdService crowdService, UserManager userManager, DarkFeatureManager darkFeatureManager) {
        this.authenticationController = authenticationController;
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.darkFeatureManager = darkFeatureManager;
    }

    private boolean isUserActiveInSynchronizedDirectory(String username) {
        return Optional.ofNullable(this.crowdService.getUser(username)).map(User::isActive).orElse(false);
    }

    private boolean isUserEligibleForApplicationFallback(String username) {
        return this.darkFeatureManager.isEnabledForAllUsers(EXTERNAL_DIRECTORY_FAILURE_HANDLING_FEATURE_KEY).orElse(false) != false && this.isUserActiveInSynchronizedDirectory(username);
    }

    @Override
    public Optional<Principal> resolvePrincipal(String username) {
        try {
            this.crowdService.userAuthenticated(username);
            return Optional.ofNullable(this.userManager.resolve(username));
        }
        catch (OperationFailedException e) {
            if (this.isUserEligibleForApplicationFallback(username)) {
                log.warn("Fetched state for user '{}' from the application database because the external directory is down.", (Object)username);
                return Optional.ofNullable(this.userManager.resolve(username));
            }
            throw new AuthenticationFailedException("Error authenticating user", e);
        }
        catch (InactiveAccountException | UserNotFoundException e) {
            log.debug("Exception caught when looking for user, treating user as not found", e);
            return Optional.empty();
        }
    }

    @Override
    public boolean isAllowedToAuthenticate(Principal principal, HttpServletRequest request) {
        return this.authenticationController.canLogin(principal, request);
    }
}

