/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.auth.callback.impl;

import com.atlassian.bitbucket.event.auth.AuthenticationFailureEvent;
import com.atlassian.bitbucket.user.CaptchaService;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.tsv.auth.callback.FailedLoginAttemptCallback;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketFailedLoginAttemptCallback
implements FailedLoginAttemptCallback {
    private static final Logger log = LoggerFactory.getLogger(BitbucketFailedLoginAttemptCallback.class);
    @VisibleForTesting
    static final String AUTHENTICATION_METHOD = "basic";
    private final CaptchaService captchaService;
    private final EventPublisher eventPublisher;

    public BitbucketFailedLoginAttemptCallback(CaptchaService captchaService, EventPublisher eventPublisher) {
        this.captchaService = captchaService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void onFailure(HttpServletRequest request, @Nonnull String username, FailedLoginAttemptCallback.FailureType failureType) {
        try {
            this.captchaService.incrementFailedAuthenticationAttemptCount(username);
            this.eventPublisher.publish((Object)new AuthenticationFailureEvent((Object)this, username, AUTHENTICATION_METHOD, null));
        }
        catch (NoSuchUserException e) {
            log.debug("Skipping failed login attempt callback for non-existent user: {}", (Object)username);
        }
    }
}

