/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.auth.callback.impl;

import com.atlassian.confluence.event.events.security.LoginDetails;
import com.atlassian.confluence.event.events.security.LoginFailedEvent;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.captcha.CaptchaService;
import com.atlassian.plugins.authentication.tsv.auth.callback.FailedLoginAttemptCallback;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Optional;

public class ConfluenceFailedLoginAttemptCallback
implements FailedLoginAttemptCallback {
    private final LoginManager loginManager;
    private final CaptchaService captchaService;
    private final EventPublisher eventPublisher;

    public ConfluenceFailedLoginAttemptCallback(LoginManager loginManager, CaptchaService captchaService, EventPublisher eventPublisher) {
        this.loginManager = loginManager;
        this.captchaService = captchaService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void onFailure(HttpServletRequest request, @Nonnull String username, FailedLoginAttemptCallback.FailureType failureType) {
        this.loginManager.onFailedLoginAttempt(username, request);
        this.eventPublisher.publish((Object)new LoginFailedEvent((Object)this, username, Optional.ofNullable(request.getSession(false)).map(HttpSession::getId).orElse("none"), request.getRemoteHost(), request.getRemoteAddr(), new LoginDetails(LoginDetails.LoginSource.DIRECT, this.getCaptchaState(username, failureType))));
    }

    private LoginDetails.CaptchaState getCaptchaState(String username, FailedLoginAttemptCallback.FailureType failureType) {
        if (failureType == FailedLoginAttemptCallback.FailureType.CAPTCHA_MISMATCH) {
            return LoginDetails.CaptchaState.FAILED;
        }
        if (!this.captchaService.isCaptchaRequired(username)) {
            return LoginDetails.CaptchaState.NOT_SHOWN;
        }
        return LoginDetails.CaptchaState.PASSED;
    }
}

