/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.auth.callback.impl;

import com.atlassian.plugins.authentication.sso.web.JiraLoginManagerWrapper;
import com.atlassian.plugins.authentication.tsv.auth.callback.FailedLoginAttemptCallback;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;

public class JiraFailedLoginAttemptCallback
implements FailedLoginAttemptCallback {
    private static final String ELEVATED_SECURITY_FAILURE_ATTRIBUTE = "com.atlassian.jira.security.login.LoginManager.ELEVATED_SECURITY_FAILURE";
    private static final String AUTHORISED_FAILURE_ATTRIBUTE = "com.atlassian.jira.security.login.LoginManager.AUTHORISED_FAILURE";
    private final JiraLoginManagerWrapper jiraLoginManagerWrapper;

    public JiraFailedLoginAttemptCallback(JiraLoginManagerWrapper jiraLoginManagerWrapper) {
        this.jiraLoginManagerWrapper = jiraLoginManagerWrapper;
    }

    @Override
    public void onFailure(HttpServletRequest request, @Nonnull String username, FailedLoginAttemptCallback.FailureType failureType) {
        this.jiraLoginManagerWrapper.doWithLoginManager(loginManager -> {
            if (failureType == FailedLoginAttemptCallback.FailureType.CAPTCHA_MISMATCH) {
                request.setAttribute(ELEVATED_SECURITY_FAILURE_ATTRIBUTE, (Object)true);
            } else if (failureType == FailedLoginAttemptCallback.FailureType.CREDENTIALS_MISMATCH) {
                request.setAttribute(AUTHORISED_FAILURE_ATTRIBUTE, (Object)true);
            }
            loginManager.onLoginAttempt(request, username, false);
            return null;
        });
    }
}

