/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.db;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.FailedFastCountException;
import com.atlassian.plugins.authentication.tsv.db.model.TotpUserEnrollmentEntity;
import com.atlassian.plugins.authentication.tsv.model.TotpUserEnrollment;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotpUserEnrollmentDao {
    private static final Logger LOG = LoggerFactory.getLogger(TotpUserEnrollmentDao.class);
    private final ActiveObjects ao;
    private final TimeZoneManager timeZoneManager;
    private final Clock clock;

    public TotpUserEnrollmentDao(ActiveObjects ao, TimeZoneManager timeZoneManager, Clock clock) {
        this.ao = ao;
        this.timeZoneManager = timeZoneManager;
        this.clock = clock;
    }

    public TotpUserEnrollment createTotpUserEnrollment(TotpUserEnrollment enrollment) {
        TotpUserEnrollmentEntity entity = (TotpUserEnrollmentEntity)this.ao.create(TotpUserEnrollmentEntity.class, this.buildRequiredFieldMap(enrollment));
        return this.mapToTotpUserEnrollment(entity);
    }

    public void findAll(Consumer<TotpUserEnrollmentEntity> consumer) {
        this.ao.executeInTransaction(() -> {
            this.ao.stream(TotpUserEnrollmentEntity.class, Query.select(), consumer::accept);
            return null;
        });
    }

    public Optional<TotpUserEnrollment> findTotpUserEnrollmentByUserKey(@Nonnull String userKey) {
        return this.findTotpUserEnrollmentInternal(userKey).map(this::mapToTotpUserEnrollment);
    }

    public Optional<TotpUserEnrollment> updateTotpUserEnrollment(TotpUserEnrollment enrollment) {
        return this.findTotpUserEnrollmentInternal(enrollment.userKey()).map(entity -> {
            entity.setSecret(enrollment.secret());
            entity.setRecoveryCode(enrollment.recoveryCode());
            entity.setModifiedAt(Date.from(this.clock.instant()));
            entity.save();
            return this.mapToTotpUserEnrollment((TotpUserEnrollmentEntity)entity);
        });
    }

    public Optional<TotpUserEnrollment> removeTotpUserEnrollmentForUser(@Nonnull String userKey) {
        return (Optional)this.ao.executeInTransaction(() -> {
            Optional<TotpUserEnrollmentEntity> optionalEntity = this.findTotpUserEnrollmentInternal(userKey);
            if (optionalEntity.isPresent()) {
                TotpUserEnrollmentEntity entity = optionalEntity.get();
                LOG.debug("Removing TOTP user enrollment for user: {}", (Object)userKey);
                this.ao.delete(new RawEntity[]{entity});
                LOG.debug("Removed TOTP user enrollment for user: {}", (Object)userKey);
                return Optional.of(this.mapToTotpUserEnrollment(entity));
            }
            return Optional.empty();
        });
    }

    public int countAllEnrollmentsFast() {
        return (Integer)this.ao.executeInTransaction(() -> {
            try {
                return this.ao.getFastCountEstimate(TotpUserEnrollmentEntity.class);
            }
            catch (FailedFastCountException | SQLException e) {
                LOG.error("Failed to count all enrollments.", e);
                throw new RuntimeException(e);
            }
        });
    }

    private ImmutableMap<String, Object> buildRequiredFieldMap(TotpUserEnrollment enrollment) {
        Instant instant = this.clock.instant();
        return ImmutableMap.builder().put((Object)"USER_KEY", (Object)enrollment.userKey()).put((Object)"SECRET", (Object)enrollment.secret()).put((Object)"RECOVERY_CODE", (Object)enrollment.recoveryCode()).put((Object)"CREATED_AT", (Object)Date.from(instant)).put((Object)"MODIFIED_AT", (Object)Date.from(instant)).build();
    }

    private Optional<TotpUserEnrollmentEntity> findTotpUserEnrollmentInternal(@Nonnull String userKey) {
        TotpUserEnrollmentEntity entity = (TotpUserEnrollmentEntity)this.ao.get(TotpUserEnrollmentEntity.class, (Object)userKey);
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.of(entity);
    }

    private TotpUserEnrollment mapToTotpUserEnrollment(TotpUserEnrollmentEntity entity) {
        return new TotpUserEnrollment(entity.getUserKey(), entity.getSecret(), entity.getRecoveryCode(), entity.getCreatedAt() == null ? null : ZonedDateTime.ofInstant(entity.getCreatedAt().toInstant(), this.timeZoneManager.getDefaultTimeZone().toZoneId()), entity.getModifiedAt() == null ? null : ZonedDateTime.ofInstant(entity.getModifiedAt().toInstant(), this.timeZoneManager.getDefaultTimeZone().toZoneId()));
    }
}

