/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.tsv.model.StatusDTO;
import com.atlassian.plugins.authentication.tsv.service.StatusService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Optional;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/status")
@BasePathDoc(value="/tsv/latest")
@Tag(name="Authentication")
@DisabledInLegacyMode
@UnlicensedSiteAccess
public class StatusResource {
    private final StatusService statusService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;

    @Inject
    public StatusResource(StatusService statusService, UserManager userManager, I18nResolver i18nResolver) {
        this.statusService = statusService;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
    }

    @Operation(description="Retrieves the status of two-step verification for the currently authenticated user.", summary="Get two-step verification status")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Successfully retrieved the two-step verification status.", representation=StatusDTO.class)})
    @GET
    public StatusDTO getStatus() {
        return Optional.ofNullable(this.userManager.getRemoteUserKey()).map(this.statusService::getStatus).orElseThrow(() -> new IllegalStateException(this.i18nResolver.getText("authentication.two-step-verification.unauthenticated.error.message")));
    }
}

