/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.exception;

import com.atlassian.plugins.authentication.common.rest.model.ErrorEntity;
import com.atlassian.plugins.authentication.tsv.exception.InvalidUseOfRateLimitAnnotationException;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class InvalidUseOfRateLimitAnnotationExceptionMapper
implements ExceptionMapper<InvalidUseOfRateLimitAnnotationException> {
    private static final Logger log = LoggerFactory.getLogger(InvalidUseOfRateLimitAnnotationExceptionMapper.class);
    private final I18nResolver i18nResolver;
    public static final String DECRYPTION_FAILED_TEXT_KEY = "authentication.two-step-verification.rate.limiting.verification.invalid.use";

    @Inject
    public InvalidUseOfRateLimitAnnotationExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(InvalidUseOfRateLimitAnnotationException exception) {
        log.error("Exception during rate limiting. UUID for this error : {}", (Object)exception.getUuid(), (Object)exception);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorEntity(this.i18nResolver.getText(DECRYPTION_FAILED_TEXT_KEY, new Serializable[]{exception.getUuid()}))).build();
    }
}

