/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit;

import com.atlassian.plugins.authentication.api.tsv.internal.exception.RateLimitedExceededException;
import com.atlassian.plugins.authentication.tsv.model.RateLimitingResult;
import com.atlassian.plugins.authentication.tsv.service.DefaultRateLimitingService;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RateLimitRequestFilter.class);
    private final DefaultRateLimitingService rateLimitingService;

    public RateLimitRequestFilter(DefaultRateLimitingService rateLimitingService) {
        this.rateLimitingService = rateLimitingService;
    }

    public void filter(@Nonnull String userKey) throws RateLimitedExceededException {
        log.debug("Check rate limit for user {}", (Object)userKey);
        RateLimitingResult rateLimitResult = this.rateLimitingService.isRequestAllowed(userKey);
        if (!rateLimitResult.isRequestAllowed()) {
            log.debug("User {} can not proceed due to exceeded rate limit", (Object)userKey);
            throw new RateLimitedExceededException(rateLimitResult.getUserRateLimitDTO());
        }
    }
}

