/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit;

import com.atlassian.plugins.authentication.api.tsv.internal.exception.RateLimitedExceededException;
import com.atlassian.plugins.authentication.tsv.model.RateLimitingResult;
import com.atlassian.plugins.authentication.tsv.service.DefaultRateLimitingService;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(RateLimitResponseFilter.class);
    private final DefaultRateLimitingService rateLimitingService;

    public RateLimitResponseFilter(DefaultRateLimitingService rateLimitingService) {
        this.rateLimitingService = rateLimitingService;
    }

    public void filter(@Nonnull String userKey, boolean verificationResult) throws RateLimitedExceededException {
        RateLimitingResult result;
        log.debug("Rate limiting on response for user {} with result {}", (Object)userKey, (Object)verificationResult);
        RateLimitingResult rateLimitingResult = result = verificationResult ? this.rateLimitingService.logSuccessfulRequest(userKey) : this.rateLimitingService.logFailedRequest(userKey);
        if (!result.isRequestAllowed()) {
            log.debug("User {} can not proceed due to exceeded rate limit", (Object)userKey);
            throw new RateLimitedExceededException(result.getUserRateLimitDTO());
        }
        log.debug("Response is allowed for user {} with verification result {}", (Object)userKey, (Object)verificationResult);
    }
}

