/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.model.conversation;

import com.atlassian.plugins.authentication.tsv.model.Method;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.CrowdSsoCookieData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.UUID;

public abstract class Conversation {
    private final String userKey;
    private final String userName;
    private final Method method;
    private final String conversationId;
    private final boolean rememberMe;
    private final CrowdSsoCookieData crowdSsoCookie;

    protected Conversation(String userKey, String username, Method method, boolean rememberMe, CrowdSsoCookieData crowdSsoCookieData) {
        this.userKey = Objects.requireNonNull(userKey);
        this.userName = Objects.requireNonNull(username);
        this.method = Objects.requireNonNull(method);
        this.rememberMe = rememberMe;
        this.conversationId = UUID.randomUUID().toString();
        this.crowdSsoCookie = crowdSsoCookieData;
    }

    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    @Nonnull
    public String getUserName() {
        return this.userName;
    }

    @Nonnull
    public Method getMethod() {
        return this.method;
    }

    @Nonnull
    public String getConversationId() {
        return this.conversationId;
    }

    public boolean getRememberMe() {
        return this.rememberMe;
    }

    @Nullable
    public CrowdSsoCookieData getCrowdSsoCookieData() {
        return this.crowdSsoCookie;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Conversation)) {
            return false;
        }
        Conversation that = (Conversation)o;
        return Objects.equals(this.getUserKey(), that.getUserKey()) && Objects.equals(this.getUserName(), that.getUserName()) && this.getMethod() == that.getMethod() && Objects.equals(this.getConversationId(), that.getConversationId()) && Objects.equals(this.getRememberMe(), that.getRememberMe()) && Objects.equals(this.getCrowdSsoCookieData(), that.getCrowdSsoCookieData());
    }

    public int hashCode() {
        return Objects.hash(this.getUserKey(), this.getUserName(), this.getMethod(), this.getConversationId(), this.getRememberMe(), this.getCrowdSsoCookieData());
    }

    public String toString() {
        return "Conversation{userKey='" + this.getUserKey() + "', userName='" + this.getUserName() + "', method=" + String.valueOf(this.getMethod()) + ", conversationId='" + this.getConversationId() + "', rememberMe='" + this.getRememberMe() + "', crowdSsoCookie='" + String.valueOf(this.getCrowdSsoCookieData()) + "'}";
    }
}

