/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.model.conversation;

import com.atlassian.plugins.authentication.tsv.model.ConversationType;
import com.atlassian.plugins.authentication.tsv.model.Method;
import com.atlassian.plugins.authentication.tsv.rest.model.conversation.Conversation;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.CrowdSsoCookieData;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class TotpEnrollConversation
extends Conversation {
    private static final Set<ConversationType> ALLOWED_CONVERSATION_TYPES = Set.of(ConversationType.ENFORCED_ENROLLMENT, ConversationType.VOLUNTARY_ENROLLMENT, ConversationType.CHANGE_AUTHENTICATION_APP);
    private final String sealedSecret;
    private final String recoveryCode;
    private final String totpURI;
    private final ConversationType type;

    public TotpEnrollConversation(String sealedSecret, String recoveryCode, String userKey, String userName, String totpURI, boolean rememberMe, ConversationType type, CrowdSsoCookieData crowdSsoCookieData) {
        super(userKey, userName, Method.TOTP, rememberMe, crowdSsoCookieData);
        Preconditions.checkArgument((boolean)ALLOWED_CONVERSATION_TYPES.contains(type));
        this.sealedSecret = Objects.requireNonNull(sealedSecret);
        this.recoveryCode = Objects.requireNonNull(recoveryCode);
        this.totpURI = totpURI;
        this.type = type;
    }

    @Nonnull
    public String getSealedSecret() {
        return this.sealedSecret;
    }

    @Nullable
    public String getTotpURI() {
        return this.totpURI;
    }

    @Nonnull
    public String getRecoveryCode() {
        return this.recoveryCode;
    }

    @Nonnull
    public ConversationType getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TotpEnrollConversation)) {
            return false;
        }
        TotpEnrollConversation that = (TotpEnrollConversation)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.getSealedSecret(), that.getSealedSecret()) && Objects.equals(this.getRecoveryCode(), that.getRecoveryCode()) && Objects.equals(this.getTotpURI(), that.getTotpURI()) && this.getType() == that.getType();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSealedSecret(), this.getRecoveryCode(), this.getTotpURI(), this.getType());
    }

    @Override
    public String toString() {
        return "TotpEnrollConversation{sealedSecret='" + this.getSealedSecret() + "', recoveryCode='" + this.getRecoveryCode() + "', totpURI='" + this.getTotpURI() + "', type='" + String.valueOf(this.getType()) + "'} " + super.toString();
    }
}

